/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch.ui;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ui.FileSystemElement;
import org.eclipse.linuxtools.profiling.launch.ui.IRemoteResourceSelectorProxy;
import org.eclipse.linuxtools.profiling.launch.ui.ResourceSelectorWidgetMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FileSystemSelectionArea {
    private Label fileSystemTitle;
    private ComboViewer fileSystems;
    private static final String EXTENSION_POINT_ID = "RemoteResourceSelectorProxy";
    private static final String RESOURCE_SELECTOR_PROXY_NAME = "resourceSelectorProxy";
    private static final String SCHEME_ID = "scheme";
    private static final String SCHEME_LABEL_ID = "schemeLabel";
    private static final String IS_DEFAULT_ID = "isDefault";
    private static final String EXT_ATTR_CLASS = "class";
    private LinkedList<FileSystemElement> fsElements;

    private FileSystemElement[] getSchemes() {
        if (this.fsElements == null) {
            this.fsElements = new LinkedList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.profiling.launch", EXTENSION_POINT_ID);
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            for (int i = 0; i < infos.length; ++i) {
                IConfigurationElement configurationElement = infos[i];
                if (!configurationElement.getName().equals(RESOURCE_SELECTOR_PROXY_NAME)) continue;
                IRemoteResourceSelectorProxy remoteSelector = null;
                try {
                    Object obj = configurationElement.createExecutableExtension(EXT_ATTR_CLASS);
                    if (obj instanceof IRemoteResourceSelectorProxy) {
                        remoteSelector = (IRemoteResourceSelectorProxy)obj;
                    }
                }
                catch (CoreException e) {
                    ProfileLaunchPlugin.log(4, ResourceSelectorWidgetMessages.FileSystemSelectionArea_exception_while_creating_runnable_class + configurationElement.getAttribute(EXT_ATTR_CLASS), e);
                }
                FileSystemElement element = new FileSystemElement(configurationElement.getAttribute(SCHEME_ID), configurationElement.getAttribute(SCHEME_LABEL_ID), Boolean.valueOf(configurationElement.getAttribute(IS_DEFAULT_ID)), remoteSelector);
                this.fsElements.addLast(element);
            }
        }
        return this.fsElements.toArray(new FileSystemElement[this.fsElements.size()]);
    }

    public void createContents(Composite composite) {
        this.fileSystemTitle = new Label(composite, 0);
        this.fileSystemTitle.setText(ResourceSelectorWidgetMessages.fileSystemSelectionText);
        this.fileSystemTitle.setFont(composite.getFont());
        this.fileSystems = new ComboViewer(composite, 8);
        this.fileSystems.getControl().setFont(composite.getFont());
        this.fileSystems.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((FileSystemElement)element).getSchemeLabel();
            }
        });
        this.fileSystems.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return FileSystemSelectionArea.this.getSchemes();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fileSystems.setInput((Object)this);
        Iterator fsEltItr = this.fsElements.iterator();
        boolean foundDefault = false;
        while (fsEltItr.hasNext()) {
            FileSystemElement fsElt = (FileSystemElement)fsEltItr.next();
            if (!fsElt.getIsDefault()) continue;
            if (foundDefault) {
                ProfileLaunchPlugin.log(2, ResourceSelectorWidgetMessages.FileSystemSelectionArea_found_multiple_default_extensions + fsElt.getScheme());
                continue;
            }
            this.fileSystems.setSelection((ISelection)new StructuredSelection((Object)fsElt));
            foundDefault = true;
        }
    }

    public FileSystemElement getSelectedFileSystem() {
        IStructuredSelection selection = this.fileSystems.getStructuredSelection();
        if (selection.size() == 1) {
            return (FileSystemElement)selection.getFirstElement();
        }
        return null;
    }

    public void setSelectedFileSystem(String scheme) throws CoreException {
        Iterator fsEltItr = this.fsElements.iterator();
        boolean foundMatch = false;
        while (fsEltItr.hasNext()) {
            FileSystemElement fsElt = (FileSystemElement)fsEltItr.next();
            if (!fsElt.getScheme().equalsIgnoreCase(scheme)) continue;
            foundMatch = true;
            this.fileSystems.setSelection((ISelection)new StructuredSelection((Object)fsElt));
            break;
        }
        if (!foundMatch) {
            throw new CoreException(Status.error((String)(ResourceSelectorWidgetMessages.FileSystemSelectionArea_unrecognized_scheme + scheme)));
        }
    }

    public void setEnabled(boolean enabled) {
        this.fileSystemTitle.setEnabled(enabled);
        this.fileSystems.getControl().setEnabled(enabled);
    }
}

