/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.project.MavenUpdateConfigurationChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectPreferencePage
extends PropertyPage {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectPreferencePage.class);
    private Button resolveWorspaceProjectsButton;
    private Button autoUpdateConfigurationButton;
    private Text selectedProfilesText;

    public MavenProjectPreferencePage() {
        this.setTitle(Messages.MavenProjectPreferencePage_title);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4));
        Label profilesLabel = new Label(composite, 0);
        profilesLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        profilesLabel.setText(Messages.MavenProjectPreferencePage_lblProfiles);
        this.selectedProfilesText = new Text(composite, 2048);
        this.selectedProfilesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.resolveWorspaceProjectsButton = new Button(composite, 32);
        this.resolveWorspaceProjectsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.resolveWorspaceProjectsButton.setText(Messages.MavenProjectPreferencePage_btnResolve);
        this.autoUpdateConfigurationButton = new Button(composite, 32);
        this.autoUpdateConfigurationButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.autoUpdateConfigurationButton.setText(Messages.MavenPreferencePage_autoUpdateProjectConfiguration);
        if (MavenUpdateConfigurationChangeListener.isAutoConfigurationUpdateDisabled()) {
            this.autoUpdateConfigurationButton.setEnabled(false);
            String text = String.valueOf(this.autoUpdateConfigurationButton.getText()) + " (disabled in workspace preferences)";
            this.autoUpdateConfigurationButton.setText(text);
        }
        this.init(this.getResolverConfiguration());
        boolean isAutoUpdate = ResolverConfigurationIO.isAutomaticallyUpdateConfiguration((IProject)this.getProject());
        this.autoUpdateConfigurationButton.setSelection(isAutoUpdate);
        return composite;
    }

    protected void performDefaults() {
        this.init(new ResolverConfiguration());
        this.autoUpdateConfigurationButton.setSelection(true);
    }

    private void init(ResolverConfiguration configuration) {
        this.resolveWorspaceProjectsButton.setSelection(configuration.isResolveWorkspaceProjects());
        this.selectedProfilesText.setText(configuration.getSelectedProfiles());
    }

    public boolean performOk() {
        boolean res;
        final IProject project = this.getProject();
        try {
            if (!project.isAccessible() || !project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                return true;
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        ResolverConfiguration configuration = new ResolverConfiguration((IProjectConfiguration)this.getResolverConfiguration());
        if (configuration.getSelectedProfiles().equals(this.selectedProfilesText.getText()) && configuration.isResolveWorkspaceProjects() == this.resolveWorspaceProjectsButton.getSelection() && ResolverConfigurationIO.isAutomaticallyUpdateConfiguration((IProject)project) == this.autoUpdateConfigurationButton.getSelection()) {
            return true;
        }
        configuration.setResolveWorkspaceProjects(this.resolveWorspaceProjectsButton.getSelection());
        ResolverConfigurationIO.setAutomaticallyUpdateConfiguration((IProject)project, (boolean)this.autoUpdateConfigurationButton.getSelection());
        configuration.setSelectedProfiles(this.selectedProfilesText.getText());
        IProjectConfigurationManager projectManager = MavenPlugin.getProjectConfigurationManager();
        boolean isSet = projectManager.setResolverConfiguration(this.getProject(), configuration);
        if (isSet && (res = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenProjectPreferencePage_dialog_title, (String)Messages.MavenProjectPreferencePage_dialog_message))) {
            WorkspaceJob job = new WorkspaceJob(NLS.bind((String)Messages.MavenProjectPreferencePage_job, (Object)project.getName())){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(project, monitor);
                    }
                    catch (CoreException ex) {
                        return ex.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
            job.schedule();
        }
        return isSet;
    }

    private ResolverConfiguration getResolverConfiguration() {
        IProjectConfigurationManager projectManager = MavenPlugin.getProjectConfigurationManager();
        return (ResolverConfiguration)projectManager.getProjectConfiguration(this.getProject());
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

