/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.project;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.internal.jobs.MavenJob;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingDiscoveryHelper;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class MavenProjectConfigurator
implements ProjectConfigurator {
    public static final String UPDATE_MAVEN_CONFIGURATION_JOB_NAME = "Update Maven projects configuration";

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        LocalProjectScanner scanner = new LocalProjectScanner(List.of(root.getAbsolutePath()), false, MavenPlugin.getMavenModelManager());
        try {
            scanner.run(monitor);
        }
        catch (Exception ex) {
            M2EUIPluginActivator.getDefault().getLog().log(Status.error((String)ex.getMessage(), (Throwable)ex));
            return null;
        }
        LinkedList projects = new LinkedList();
        projects.addAll(scanner.getProjects());
        HashSet<File> res = new HashSet<File>();
        while (!projects.isEmpty()) {
            MavenProjectInfo projectInfo = (MavenProjectInfo)projects.poll();
            res.add(projectInfo.getPomFile().getParentFile());
            projects.addAll(projectInfo.getProjects());
        }
        return res;
    }

    public void removeDirtyDirectories(Map<File, List<ProjectConfigurator>> proposals) {
        HashSet<File> toRemove = new HashSet<File>();
        for (File directory : proposals.keySet()) {
            File potentialPomFile;
            int index;
            String path = directory.getAbsolutePath();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            if ((index = path.indexOf(String.valueOf(File.separator) + "target" + File.separator)) < 0 || !(potentialPomFile = new File(path.substring(0, index), "pom.xml")).isFile()) continue;
            toRemove.add(directory);
        }
        for (File directory : toRemove) {
            proposals.remove(directory);
        }
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public void configure(IProject project, Set<IPath> excludedDirectories, IProgressMonitor monitor) {
        ResolverConfiguration configuration = new ResolverConfiguration(project);
        configuration.setResolveWorkspaceProjects(true);
        try {
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
                newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
                description.setNatureIds(newNatures);
                project.setDescription(description, monitor);
            }
            UpdateMavenConfigurationJob.getInstance().addProjectToProcess(project);
            if (UpdateMavenConfigurationJob.getInstance().getState() == 0) {
                UpdateMavenConfigurationJob.getInstance().schedule();
            }
        }
        catch (Exception ex) {
            M2EUIPluginActivator.getDefault().getLog().log(Status.error((String)ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        IFile pomFile = container.getFile(IPath.fromOSString((String)"pom.xml"));
        return pomFile.exists();
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        res.add(project.getFolder("src"));
        res.add(project.getFolder("target"));
        return res;
    }

    private static class CumulativeMappingDiscoveryJob
    extends MappingDiscoveryJob {
        private static CumulativeMappingDiscoveryJob INSTANCE;
        private final Set<IProject> toProcess = Collections.synchronizedSet(new HashSet());
        private boolean started;

        public static synchronized CumulativeMappingDiscoveryJob getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new CumulativeMappingDiscoveryJob();
            }
            return INSTANCE;
        }

        private CumulativeMappingDiscoveryJob() {
            super(Collections.emptyList(), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                CumulativeMappingDiscoveryJob.getJobManager().join(SmartImportJob.class, monitor);
            }
            catch (InterruptedException ex) {
                throw new CoreException((IStatus)Status.warning((String)ex.getMessage(), (Throwable)ex));
            }
            Set<IProject> ex = this.toProcess;
            synchronized (ex) {
                this.started = true;
            }
            try {
                LifecycleMappingDiscoveryRequest discoveryRequest = LifecycleMappingDiscoveryHelper.createLifecycleMappingDiscoveryRequest(this.toProcess, monitor);
                if (discoveryRequest.isMappingComplete()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                this.discoverProposals(discoveryRequest, monitor);
                Map proposals = discoveryRequest.getAllProposals();
                if (proposals.isEmpty()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                this.openProposalWizard(this.toProcess, discoveryRequest);
            }
            finally {
                this.toProcess.clear();
                this.started = false;
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjects(Collection<IProject> projects) {
            Set<IProject> set = this.toProcess;
            synchronized (set) {
                if (this.started) {
                    throw new IllegalStateException("Cannot add projects when processing is started");
                }
                if (projects != null) {
                    this.toProcess.addAll(projects);
                }
            }
        }
    }

    public static class UpdateMavenConfigurationJob
    extends MavenJob
    implements IBackgroundProcessingQueue {
        private static UpdateMavenConfigurationJob INSTANCE;
        private final Set<IProject> toProcess = Collections.synchronizedSet(new HashSet());

        public static synchronized UpdateMavenConfigurationJob getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new UpdateMavenConfigurationJob();
            }
            return INSTANCE;
        }

        private UpdateMavenConfigurationJob() {
            super(MavenProjectConfigurator.UPDATE_MAVEN_CONFIGURATION_JOB_NAME);
            this.setUser(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToProcess(IProject project) {
            Set<IProject> set = this.toProcess;
            synchronized (set) {
                this.toProcess.add(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            HashSet<IProject> toProcessNow = new HashSet<IProject>();
            while (!monitor.isCanceled()) {
                Set<IProject> set = this.toProcess;
                synchronized (set) {
                    if (this.toProcess.isEmpty()) {
                        CumulativeMappingDiscoveryJob.getInstance().schedule();
                        return Status.OK_STATUS;
                    }
                    toProcessNow.addAll(this.toProcess);
                    this.toProcess.removeAll(toProcessNow);
                }
                if (toProcessNow.isEmpty()) continue;
                CumulativeMappingDiscoveryJob.getInstance().addProjects(toProcessNow);
                ProjectConfigurationManager configurationManager = (ProjectConfigurationManager)MavenPlugin.getProjectConfigurationManager();
                MavenUpdateRequest request = new MavenUpdateRequest(toProcessNow, false, false);
                configurationManager.updateProjectConfiguration(request, true, false, false, monitor);
            }
            return new Status(8, "org.eclipse.m2e.core.ui", "Cancelled by user");
        }

        public boolean isEmpty() {
            return this.toProcess.isEmpty();
        }
    }
}

