/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PomTemplateContextUtil {
    private static final Logger log = LoggerFactory.getLogger(PomTemplateContextUtil.class);
    public static final PomTemplateContextUtil INSTANCE = new PomTemplateContextUtil();
    private final Map<String, PluginDescriptor> descriptors = new HashMap<String, PluginDescriptor>();

    PomTemplateContextUtil() {
    }

    public PluginDescriptor getPluginDescriptor(String groupId, String artifactId, String version) {
        block17: {
            String name = String.valueOf(groupId) + ":" + artifactId + ":" + version;
            PluginDescriptor descriptor = this.descriptors.get(name);
            if (descriptor != null) {
                return descriptor;
            }
            try {
                IMaven embedder = MavenPlugin.getMaven();
                List repositories = embedder.getArtifactRepositories();
                Artifact artifact = embedder.resolve(groupId, artifactId, version, "maven-plugin", null, repositories, null);
                File file = artifact.getFile();
                if (file == null) {
                    String msg = "Can't resolve plugin " + name;
                    log.error(msg);
                    break block17;
                }
                try {
                    Throwable msg = null;
                    Object var11_17 = null;
                    try (ZipFile zf = new ZipFile(file);){
                        ZipEntry entry = zf.getEntry("META-INF/maven/plugin.xml");
                        if (entry != null) {
                            InputStream is = zf.getInputStream(entry);
                            PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
                            descriptor = builder.build((Reader)new InputStreamReader(is));
                            this.descriptors.put(name, descriptor);
                            return descriptor;
                        }
                    }
                    catch (Throwable throwable) {
                        if (msg == null) {
                            msg = throwable;
                        } else if (msg != throwable) {
                            msg.addSuppressed(throwable);
                        }
                        throw msg;
                    }
                }
                catch (Exception ex) {
                    String msg = "Can't read configuration for " + name;
                    log.error(msg, (Throwable)ex);
                }
            }
            catch (CoreException ex) {
                IStatus status = ex.getStatus();
                String msg = status.getMessage();
                if (status.getException() != null) {
                    msg = String.valueOf(msg) + "; " + status.getException().getMessage();
                }
                log.error(msg, (Throwable)ex);
            }
        }
        return null;
    }
}

