/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.builds.core.IParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BooleanParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BuildParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.ChoiceParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.FileParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.PasswordParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.StringParameterDefinition;
import org.eclipse.mylyn.internal.builds.ui.view.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParametersDialog
extends TitleAreaDialog {
    private final Map<String, Control> controls = new HashMap<String, Control>();
    private final BuildPlan plan;
    private Map<String, String> parameters;

    public ParametersDialog(Shell parentShell, BuildPlan plan) {
        super(parentShell);
        this.plan = plan;
        this.setHelpAvailable(false);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ParametersDialog_runBuild);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(NLS.bind((String)Messages.ParametersDialog_buildPlan, (Object)this.plan.getLabel()));
        Composite pane = new Composite(composite, 0);
        pane.setLayoutData((Object)new GridData(1808));
        pane.setLayout((Layout)new GridLayout(2, false));
        for (final IParameterDefinition definition : this.plan.getParameterDefinitions()) {
            String name = definition.getName();
            Label label = new Label(pane, 0);
            label.setText(name);
            Control control = this.addParameter(pane, definition);
            if (control instanceof Text) {
                GridDataFactory.fillDefaults().hint(this.convertVerticalDLUsToPixels(200), -1).applyTo(control);
            }
            control.addFocusListener((FocusListener)new FocusAdapter(){
                private boolean firstTime = true;

                public void focusGained(FocusEvent e) {
                    if (this.firstTime) {
                        ParametersDialog.this.setMessage(Messages.ParametersDialog_provideBuildParameters);
                        this.firstTime = false;
                    } else {
                        ParametersDialog.this.setMessage(definition.getDescription());
                    }
                }
            });
            this.controls.put(name, control);
        }
        return composite;
    }

    /*
     * WARNING - void declaration
     */
    private Control addParameter(Composite pane, IParameterDefinition definition) {
        IParameterDefinition iParameterDefinition = definition;
        if (iParameterDefinition instanceof ChoiceParameterDefinition) {
            int i;
            void def;
            ChoiceParameterDefinition choiceParameterDefinition = (ChoiceParameterDefinition)iParameterDefinition;
            ChoiceParameterDefinition cfr_ignored_0 = (ChoiceParameterDefinition)iParameterDefinition;
            Combo control = new Combo(pane, 2052);
            for (String option : def.getOptions()) {
                control.add(option);
            }
            if (def.getDefaultValue() != null && (i = control.indexOf(def.getDefaultValue())) != -1) {
                control.select(i);
            }
            return control;
        }
        IParameterDefinition iParameterDefinition2 = definition;
        if (iParameterDefinition2 instanceof BooleanParameterDefinition) {
            void def;
            BooleanParameterDefinition control = (BooleanParameterDefinition)iParameterDefinition2;
            BooleanParameterDefinition cfr_ignored_1 = (BooleanParameterDefinition)iParameterDefinition2;
            Button control2 = new Button(pane, 2080);
            control2.setSelection(def.isDefaultValue());
            return control2;
        }
        IParameterDefinition iParameterDefinition3 = definition;
        if (iParameterDefinition3 instanceof StringParameterDefinition) {
            void def;
            StringParameterDefinition control2 = (StringParameterDefinition)iParameterDefinition3;
            StringParameterDefinition cfr_ignored_2 = (StringParameterDefinition)iParameterDefinition3;
            Text control = new Text(pane, 2048);
            control.setText(this.toValue(def.getDefaultValue()));
            return control;
        }
        IParameterDefinition iParameterDefinition4 = definition;
        if (iParameterDefinition4 instanceof PasswordParameterDefinition) {
            void def;
            PasswordParameterDefinition control = (PasswordParameterDefinition)iParameterDefinition4;
            PasswordParameterDefinition cfr_ignored_3 = (PasswordParameterDefinition)iParameterDefinition4;
            Text control3 = new Text(pane, 2048);
            control3.setEchoChar('*');
            control3.setText(this.toValue(def.getDefaultValue()));
            return control3;
        }
        IParameterDefinition iParameterDefinition5 = definition;
        if (iParameterDefinition5 instanceof BuildParameterDefinition) {
            void def;
            BuildParameterDefinition control3 = (BuildParameterDefinition)iParameterDefinition5;
            BuildParameterDefinition cfr_ignored_4 = (BuildParameterDefinition)iParameterDefinition5;
            Text control = new Text(pane, 2048);
            control.setText(this.toValue(def.getBuildPlanId()));
            return control;
        }
        if (definition instanceof FileParameterDefinition) {
            Text control = new Text(pane, 2048);
            return control;
        }
        throw new IllegalArgumentException(Messages.ParametersDialog_unexpectedDefinitionType + definition.getClass().getName());
    }

    private String toValue(String defaultValue) {
        return defaultValue != null ? defaultValue : "";
    }

    protected void okPressed() {
        this.parameters = new HashMap<String, String>();
        for (IParameterDefinition definition : this.plan.getParameterDefinitions()) {
            String name = definition.getName();
            Control control = this.controls.get(name);
            String parameter = this.getParameter(control);
            if (parameter == null) continue;
            this.parameters.put(name, parameter);
        }
        super.okPressed();
    }

    /*
     * WARNING - void declaration
     */
    private String getParameter(Control control) {
        Control control2 = control;
        if (control2 instanceof Combo) {
            void combo;
            Combo combo2 = (Combo)control2;
            Combo cfr_ignored_0 = (Combo)control2;
            return combo.getText();
        }
        Control control3 = control;
        if (control3 instanceof Button) {
            void button;
            Button button2 = (Button)control3;
            Button cfr_ignored_1 = (Button)control3;
            if (button.getSelection()) {
                return "on";
            }
            return null;
        }
        Control control4 = control;
        if (control4 instanceof Text) {
            void text;
            Text text2 = (Text)control4;
            Text cfr_ignored_2 = (Text)control4;
            return text.getText();
        }
        throw new IllegalArgumentException(Messages.ParametersDialog_unexpectedControlType + control.getClass().getName());
    }
}

