/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.osgi.util.NLS;

public class SynchronizeRepositoriesJob
extends SynchronizationJob {
    private static final boolean TRACE_ENABLED = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.core/debug/synchronization"));
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private Set<TaskRepository> repositories;
    private final IRepositoryModel tasksModel;
    private final Map<QualifiedName, Object> properties = new ConcurrentHashMap<QualifiedName, Object>();

    public SynchronizeRepositoriesJob(TaskList taskList, TaskDataManager taskDataManager, IRepositoryModel tasksModel, IRepositoryManager repositoryManager) {
        super(Messages.SynchronizeRepositoriesJob_Synchronizing_Task_List);
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.tasksModel = tasksModel;
        this.repositoryManager = repositoryManager;
    }

    public Collection<TaskRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public void setRepositories(Collection<TaskRepository> repositories) {
        this.repositories = repositories != null ? new HashSet<TaskRepository>(repositories) : null;
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor jobMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateQueries(TaskRepository repository, AbstractRepositoryConnector connector, Set<RepositoryQuery> queries, IProgressMonitor monitor) {
        if (this.isUser()) {
            for (RepositoryQuery query : queries) {
                query.setSynchronizing(true);
            }
            this.taskList.notifySynchronizationStateChanged(queries);
        }
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries){

            public boolean belongsTo(Object family) {
                return ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION == family;
            }
        };
        job.setFetchSubtasks(this.getFetchSubtasks());
        job.setUser(this.isUser());
        job.setFullSynchronization(true);
        job.setPriority(50);
        this.copyPropertiesTo(job);
        if (this.isUser()) {
            job.schedule();
        } else {
            job.run((IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
    }

    private void copyPropertiesTo(SynchronizeQueriesJob job) {
        for (QualifiedName key : this.properties.keySet()) {
            job.setProperty(key, this.properties.get(key));
        }
    }

    public void setProperty(QualifiedName key, Object value) {
        super.setProperty(key, value);
        this.properties.put(key, value);
    }

    public boolean belongsTo(Object family) {
        return ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION == family;
    }

    private void updateRepositoryConfiguration(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
        try {
            try {
                if (!this.isUser()) {
                    monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
                }
                monitor.beginTask(MessageFormat.format(Messages.SynchronizeRepositoriesJob_Updating_repository_configuration_for_X, repository.getRepositoryUrl()), 100);
                if (connector.isRepositoryConfigurationStale(repository, monitor)) {
                    if (TRACE_ENABLED) {
                        this.trace("Updating configuration for " + repository.getRepositoryLabel());
                    }
                    connector.updateRepositoryConfiguration(repository, monitor);
                    repository.setConfigurationDate(new Date());
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                repository.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Updating of repository configuration failed", (Throwable)e));
                monitor.done();
            }
            catch (LinkageError e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Internal error while updating repository configuration for ''{0}''", (Object)repository.getUrl()), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void trace(String message) {
        System.err.println("[" + String.valueOf(new Date()) + "] " + message);
    }
}

