/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.data.TextTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.ui.TaskDropListener;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TaskAttachmentDropListener
implements DropTargetListener {
    private final AbstractTaskEditorPage page;

    public TaskAttachmentDropListener(AbstractTaskEditorPage page) {
        this.page = page;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (LocalSelectionTransfer.getTransfer().isSupportedType(dataType) || FileTransfer.getInstance().isSupportedType(dataType)) {
                event.currentDataType = dataType;
                if (event.detail == 1) break;
                event.detail = 0;
                break;
            }
            ++n2;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = event.detail == 16 || (event.operations & 1) != 0 ? 1 : 0;
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            TasksUiInternal.getTaskDropHandler().loadTaskDropListeners();
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            List<ITask> tasksToMove = TasksUiInternal.getTasksFromSelection(selection);
            if (!tasksToMove.isEmpty()) {
                TasksUiInternal.getTaskDropHandler().fireTaskDropped(tasksToMove, this.page.getTask(), TaskDropListener.Operation.DROP_ON_TASK_EDITOR);
            } else {
                this.attachFirstFile(TaskAttachmentDropListener.getFilesFromSelection(selection));
            }
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            EditorUtil.openNewAttachmentWizard(this.page, null, (AbstractTaskAttachmentSource)new TextTaskAttachmentSource(text));
        }
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String[] files = (String[])event.data;
            this.attachFirstFile(files);
        }
    }

    protected void attachFirstFile(String[] files) {
        if (files != null && files.length > 0) {
            File file = new File(files[0]);
            NewAttachmentWizardDialog dialog = EditorUtil.openNewAttachmentWizard(this.page, null, (AbstractTaskAttachmentSource)new FileTaskAttachmentSource(file));
            if (files.length > 1) {
                dialog.setMessage(Messages.TaskAttachmentDropListener_Note_that_only_the_first_file_dragged_will_be_attached, 2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getFilesFromSelection(ISelection selection) {
        ArrayList<String> files = new ArrayList<String>();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                IResource resource = null;
                if (element instanceof IResource) {
                    resource = (IResource)element;
                } else {
                    Object e = element;
                    if (e instanceof IAdaptable) {
                        void adaptable;
                        IAdaptable cfr_ignored_0 = (IAdaptable)e;
                        IAdaptable cfr_ignored_1 = (IAdaptable)e;
                        resource = (IResource)adaptable.getAdapter(IResource.class);
                    }
                }
                if (resource == null || resource.getRawLocation() == null) continue;
                files.add(resource.getRawLocation().toOSString());
            }
        }
        return files.toArray(new String[files.size()]);
    }
}

