/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.DelayedRefreshJob;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListView;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public final class TaskListRefreshJob
extends DelayedRefreshJob {
    private final AbstractTaskListView taskListView;
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(final Set<TaskContainerDelta> deltas) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (TaskContainerDelta taskContainerDelta : deltas) {
                        if ((this).TaskListRefreshJob.this.taskListView.isScheduledPresentation()) {
                            TaskListRefreshJob.this.refresh();
                            continue;
                        }
                        switch (taskContainerDelta.getKind()) {
                            case ROOT: {
                                TaskListRefreshJob.this.refresh();
                                break;
                            }
                            case ADDED: 
                            case REMOVED: {
                                if (this.isFilteredContainer(taskContainerDelta)) {
                                    TaskListRefreshJob.this.refresh();
                                    break;
                                }
                                if (taskContainerDelta.getElement() != null) {
                                    TaskListRefreshJob.this.refreshElement(taskContainerDelta.getElement());
                                }
                                if (taskContainerDelta.getParent() != null) {
                                    TaskListRefreshJob.this.refreshElement(taskContainerDelta.getParent());
                                    break;
                                }
                                TaskListRefreshJob.this.refresh();
                                break;
                            }
                            case CONTENT: {
                                TaskListRefreshJob.this.refreshElement(taskContainerDelta.getElement());
                            }
                        }
                    }
                }

                private boolean isFilteredContainer(TaskContainerDelta taskContainerDelta) {
                    ITaskContainer parent = taskContainerDelta.getParent();
                    return parent instanceof UnsubmittedTaskContainer || parent instanceof UnmatchedTaskContainer || parent instanceof UncategorizedTaskContainer;
                }
            });
        }
    };

    public TaskListRefreshJob(AbstractTaskListView taskListView, TreeViewer treeViewer, String name) {
        super((StructuredViewer)treeViewer, name);
        this.taskListView = taskListView;
        TasksUiInternal.getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    protected void doRefresh(Object[] items) {
        TreePath selection = this.preserveSelection();
        if (items == null) {
            this.viewer.refresh(true);
        } else if (items.length > 0) {
            try {
                if (this.taskListView.isFocusedMode()) {
                    Object item2;
                    HashSet<Object> children = new HashSet<Object>(Arrays.asList(items));
                    HashSet parents = new HashSet();
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        item2 = objectArray[n2];
                        if (item2 instanceof AbstractTask) {
                            parents.addAll(((AbstractTask)item2).getParentContainers());
                        }
                        ++n2;
                    }
                    children.removeAll(parents);
                    for (AbstractTaskContainer parent : parents) {
                        this.viewer.refresh((Object)parent, false);
                        this.viewer.update((Object)parent, null);
                    }
                    for (Object item2 : children) {
                        this.viewer.refresh(item2, true);
                    }
                    objectArray = items;
                    n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        item2 = objectArray[n3];
                        this.updateExpansionState(item2);
                        ++n3;
                    }
                } else {
                    HashSet parents = new HashSet();
                    Object[] objectArray = items;
                    int n = items.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Object item = objectArray[n4];
                        if (item instanceof AbstractTask) {
                            parents.addAll(((AbstractTask)item).getParentContainers());
                        }
                        this.viewer.refresh(item, true);
                        this.updateExpansionState(item);
                        ++n4;
                    }
                    for (AbstractTaskContainer parent : parents) {
                        this.viewer.update((Object)parent, null);
                    }
                }
            }
            catch (SWTException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to refresh viewer: " + String.valueOf(this.viewer), (Throwable)e));
            }
        }
        this.taskListView.updateToolTip(false);
        this.restoreSelection(selection);
    }

    /*
     * WARNING - void declaration
     */
    private TreePath preserveSelection() {
        StructuredViewer structuredViewer = this.viewer;
        if (structuredViewer instanceof TreeViewer) {
            void treeViewer;
            TreeViewer treeViewer2 = (TreeViewer)structuredViewer;
            TreeViewer cfr_ignored_0 = (TreeViewer)structuredViewer;
            TreeItem[] selection = treeViewer.getTree().getSelection();
            if (selection.length > 0) {
                TreeWalker treeWalker = new TreeWalker((TreeViewer)treeViewer);
                return treeWalker.walk(new TreeWalker.TreeVisitor(){

                    @Override
                    public boolean visit(Object object) {
                        return true;
                    }
                }, selection[selection.length - 1]);
            }
        }
        return null;
    }

    private void restoreSelection(TreePath treePath) {
        ISelection newSelection;
        if (treePath != null && ((newSelection = this.viewer.getSelection()) == null || newSelection.isEmpty())) {
            this.viewer.setSelection((ISelection)new TreeSelection(treePath), true);
        }
    }

    protected void updateExpansionState(Object item) {
        if (this.taskListView.isFocusedMode() && this.taskListView.isAutoExpandMode()) {
            this.taskListView.getViewer().expandToLevel(item, 3);
        }
    }

    public void dispose() {
        TasksUiInternal.getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }
}

