/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.framework.FilterTableEntry;
import org.eclipse.ocl.examples.eventmanager.framework.Registration;
import org.eclipse.ocl.examples.eventmanager.util.Bag;
import org.eclipse.ocl.examples.eventmanager.util.BagImpl;
import org.eclipse.ocl.examples.eventmanager.util.CompositeBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableForEventFilter {
    private final Bag<Registration>[] completeNoBag;
    private final int numberOfFilterTables;
    private final Bag<Registration>[] emptyRegistrationArray;
    protected final HashMap<Registration, Object> filterCriteriaByRegistration = new HashMap();
    protected final Map<Object, FilterTableEntry> tableEntryByFilterCriterion = new HashMap<Object, FilterTableEntry>();

    protected TableForEventFilter(int numberOfFilterTables) {
        this.numberOfFilterTables = numberOfFilterTables;
        this.completeNoBag = new Bag[1 << numberOfFilterTables];
        this.emptyRegistrationArray = new Bag[1 << numberOfFilterTables];
    }

    public abstract Object getAffectedObject(Notification var1);

    protected String criterionToString(Object criterion) {
        return criterion.toString();
    }

    void register(EventFilter filter, Registration registration) {
        FilterTableEntry entry = this.tableEntryByFilterCriterion.get(filter.getFilterCriterion());
        if (entry == null) {
            entry = new FilterTableEntry(this.numberOfFilterTables);
            this.tableEntryByFilterCriterion.put(filter.getFilterCriterion(), entry);
        }
        if (filter.isNegated()) {
            entry.addNegatedRegistrations(registration);
            int tableBitSet = registration.getBitSetForTablesRegisteredWith();
            Bag<Registration> completeNoBagForTableCombination = this.completeNoBag[tableBitSet];
            if (completeNoBagForTableCombination == null) {
                this.completeNoBag[tableBitSet] = completeNoBagForTableCombination = new BagImpl<Registration>();
            }
            completeNoBagForTableCombination.add(registration);
        } else {
            entry.addRegistrations(registration);
        }
        Object criterion = this.filterCriteriaByRegistration.get(registration);
        if (criterion == null) {
            this.filterCriteriaByRegistration.put(registration, filter.getFilterCriterion());
        } else if (criterion instanceof List) {
            ((List)criterion).add(filter.getFilterCriterion());
        } else {
            ArrayList<Object> criteria = new ArrayList<Object>(2);
            criteria.add(criterion);
            criteria.add(filter.getFilterCriterion());
            this.filterCriteriaByRegistration.put(registration, criteria);
        }
    }

    void deregister(Registration registration) {
        Object criterion = this.filterCriteriaByRegistration.get(registration);
        if (criterion != null) {
            if (criterion instanceof List) {
                for (Object filterCriterion : (List)criterion) {
                    this._deregister(registration, filterCriterion);
                }
            } else {
                this._deregister(registration, criterion);
            }
            this.filterCriteriaByRegistration.remove(registration);
        }
    }

    private void _deregister(Registration registration, Object criterion) {
        Bag<Registration> completeNoBagEntry;
        FilterTableEntry entry = this.tableEntryByFilterCriterion.get(criterion);
        if (entry != null) {
            entry.remove(registration);
            if (entry.isEmpty()) {
                this.tableEntryByFilterCriterion.remove(criterion);
            }
        }
        if ((completeNoBagEntry = this.completeNoBag[registration.getBitSetForTablesRegisteredWith()]) != null && completeNoBagEntry.remove(registration) && completeNoBagEntry.isEmpty()) {
            this.completeNoBag[registration.getBitSetForTablesRegisteredWith()] = null;
        }
    }

    Bag<Registration>[] getYesSetsFor(Notification event, int numberOfBitSetsWithAtLeastOneRegistration, int[] bitSetsWithAtLeastOneRegistration) {
        return this.getSetsFor(event, SetSelection.YES, numberOfBitSetsWithAtLeastOneRegistration, bitSetsWithAtLeastOneRegistration);
    }

    Bag<Registration>[] getNoSetsFor(Notification event, int numberOfBitSetsWithAtLeastOneRegistration, int[] bitSetsWithAtLeastOneRegistration) {
        return this.getSetsFor(event, SetSelection.NO, numberOfBitSetsWithAtLeastOneRegistration, bitSetsWithAtLeastOneRegistration);
    }

    private Bag<Registration>[] getSetsFor(Notification event, SetSelection yesNoSelection, int numberOfBitSetsWithAtLeastOneRegistration, int[] bitSetsWithAtLeastOneRegistration) {
        Bag<Registration>[] resultBagArray;
        Object affectedFilterTableEntryKeys = this.getAffectedObject(event);
        Set<FilterTableEntry> filterTableEntries = this.getFilterTableEntries(affectedFilterTableEntryKeys);
        switch (filterTableEntries.size()) {
            case 0: {
                resultBagArray = this.emptyRegistrationArray;
                break;
            }
            case 1: {
                if (yesNoSelection == SetSelection.YES) {
                    resultBagArray = filterTableEntries.iterator().next().getYesSets();
                    break;
                }
                resultBagArray = filterTableEntries.iterator().next().getNoSets();
                break;
            }
            default: {
                resultBagArray = new Bag[1 << this.numberOfFilterTables];
                int i = 0;
                while (i < numberOfBitSetsWithAtLeastOneRegistration) {
                    ArrayList<Bag<Registration>> bagList = new ArrayList<Bag<Registration>>();
                    for (FilterTableEntry filterTableEntry : filterTableEntries) {
                        Bag<Registration> yesSetForTableEntryAtBitSet = yesNoSelection == SetSelection.YES ? filterTableEntry.getYesSet(bitSetsWithAtLeastOneRegistration[i]) : filterTableEntry.getNoSet(bitSetsWithAtLeastOneRegistration[i]);
                        if (yesSetForTableEntryAtBitSet == null) continue;
                        bagList.add(yesSetForTableEntryAtBitSet);
                    }
                    CompositeBag compositeBagAtBitSet = null;
                    if (!bagList.isEmpty()) {
                        compositeBagAtBitSet = new CompositeBag(bagList.toArray(new Bag[0]));
                    }
                    resultBagArray[bitSetsWithAtLeastOneRegistration[i]] = compositeBagAtBitSet;
                    ++i;
                }
                break block0;
            }
        }
        return resultBagArray;
    }

    private Set<FilterTableEntry> getFilterTableEntries(Object affectedFilterTableEntryKeys) {
        FilterTableEntry tableEntry;
        Set<FilterTableEntry> filterTableEntries = Collections.emptySet();
        if (affectedFilterTableEntryKeys instanceof Collection) {
            if (!(affectedFilterTableEntryKeys instanceof Set)) {
                affectedFilterTableEntryKeys = new HashSet(affectedFilterTableEntryKeys);
            }
            if (!this.tableEntryByFilterCriterion.isEmpty()) {
                filterTableEntries = new HashSet<FilterTableEntry>();
                for (Object criterion : (Set)affectedFilterTableEntryKeys) {
                    FilterTableEntry fte = this.tableEntryByFilterCriterion.get(criterion);
                    if (fte == null) continue;
                    filterTableEntries.add(fte);
                }
            }
        } else if (affectedFilterTableEntryKeys != null && (tableEntry = this.tableEntryByFilterCriterion.get(affectedFilterTableEntryKeys)) != null) {
            filterTableEntries = Collections.singleton(tableEntry);
        }
        return filterTableEntries;
    }

    protected boolean isEmpty() {
        if (!this.tableEntryByFilterCriterion.isEmpty()) {
            return false;
        }
        Bag<Registration>[] bagArray = this.completeNoBag;
        int n = this.completeNoBag.length;
        int n2 = 0;
        while (n2 < n) {
            Bag<Registration> completeNoBagEntry = bagArray[n2];
            if (completeNoBagEntry != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean isRegistered(Registration reg) {
        return this.filterCriteriaByRegistration.containsKey(reg);
    }

    public abstract Class<? extends EventFilter> getIdentifier();

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(": ");
        boolean appendedSomeNoSetStuff = false;
        int i = 0;
        while (i < this.completeNoBag.length) {
            if (this.completeNoBag[i] != null) {
                appendedSomeNoSetStuff = true;
                result.append(", completeNoSet[" + i + "].size()=");
                result.append(this.completeNoBag[i].size());
            }
            ++i;
        }
        if (appendedSomeNoSetStuff) {
            result.append(", ");
        }
        result.append("FilterTableByCriterion=(\n");
        boolean first = true;
        for (Object criterion : this.tableEntryByFilterCriterion.keySet()) {
            if (!first) {
                result.append(",\n");
            } else {
                first = false;
            }
            result.append(" ");
            result.append(this.criterionToString(criterion));
            result.append(":\n");
            result.append(this.tableEntryByFilterCriterion.get(criterion));
        }
        result.append(")");
        return result.toString();
    }

    public Bag<Registration>[] getCompleteNoBag() {
        return this.completeNoBag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetSelection {
        YES,
        NO;

    }
}

