/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.ui.ManifestDiscoveryDialog;
import org.eclipse.oomph.targlets.internal.ui.Messages;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformListener;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.plugin.PluginBaseNode;
import org.eclipse.pde.internal.core.text.plugin.PluginDocumentNodeFactory;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ManifestDiscovery {
    public static final ManifestDiscovery INSTANCE = new ManifestDiscovery();
    private static final Set<DiscoverListener> DISCOVERY_LISTENERS = new HashSet<DiscoverListener>();
    private static List<ITargletContainer> targletContainers;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.addPageListener(ManifestDiscovery.this.pageListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePageListener(ManifestDiscovery.this.pageListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private final IPageListener pageListener = new IPageListener(){

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener(ManifestDiscovery.this.partListener);
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(ManifestDiscovery.this.partListener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }
    };
    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            try {
                if (part instanceof ManifestEditor) {
                    ManifestEditor manifestEditor = (ManifestEditor)part;
                    ManifestDiscovery.this.handleManifestEditor(manifestEditor);
                    manifestEditor.addPageChangedListener(ManifestDiscovery.this.pageChangedListener);
                }
            }
            catch (Throwable ex) {
                TargletsUIPlugin.INSTANCE.log(ex, 2);
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };
    private final IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            Object page = event.getSelectedPage();
            ManifestDiscovery.this.handleDependenciesPage(page);
        }
    };

    private ManifestDiscovery() {
    }

    public void start() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        UIUtil.asyncExec((Display)workbench.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                            int n5 = iEditorReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IEditorPart editorPart;
                                IEditorReference editorReference = iEditorReferenceArray[n6];
                                if ("org.eclipse.pde.ui.manifestEditor".equals(editorReference.getId()) && (editorPart = editorReference.getEditor(false)) instanceof ManifestEditor) {
                                    ManifestEditor manifestEditor = (ManifestEditor)editorPart;
                                    ManifestDiscovery.this.handleManifestEditor(manifestEditor);
                                    manifestEditor.addPageChangedListener(ManifestDiscovery.this.pageChangedListener);
                                }
                                ++n6;
                            }
                            page.addPartListener(ManifestDiscovery.this.partListener);
                            ++n4;
                        }
                        window.addPageListener(ManifestDiscovery.this.pageListener);
                        ++n2;
                    }
                    workbench.addWindowListener(ManifestDiscovery.this.windowListener);
                    ITargetDefinition activeTargetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
                    ManifestDiscovery.this.handleTargetDefinition(workbench, activeTargetDefinition);
                    TargetPlatformUtil.addListener((TargetPlatformListener)new TargetPlatformListener(){

                        public void targetDefinitionActivated(ITargetDefinition oldTargetDefinition, ITargetDefinition newTargetDefinition) throws Exception {
                            ManifestDiscovery.this.handleTargetDefinition(workbench, newTargetDefinition);
                        }
                    });
                }
                catch (Throwable ex) {
                    TargletsUIPlugin.INSTANCE.log(ex, 2);
                }
            }
        });
    }

    private void handleManifestEditor(ManifestEditor manifestEditor) {
        IFormPage pageInstance = manifestEditor.getActivePageInstance();
        this.handleDependenciesPage(pageInstance);
    }

    private void handleDependenciesPage(Object page) {
        try {
            if (page instanceof DependenciesPage) {
                Button newButton;
                FormToolkit toolkit;
                DependenciesPage dependenciesPage = (DependenciesPage)page;
                Control control = dependenciesPage.getPartControl();
                ScrolledForm scrolledForm = (ScrolledForm)control;
                Form form = scrolledForm.getForm();
                Composite layoutComposite = (Composite)form.getChildren()[1];
                Composite composite1 = (Composite)layoutComposite.getChildren()[0];
                Section section = (Section)composite1.getChildren()[0];
                Composite composite2 = (Composite)section.getChildren()[2];
                Composite composite3 = (Composite)composite2.getChildren()[1];
                Button button = (Button)composite3.getChildren()[1];
                if (!(button.getData() instanceof DiscoverPluginsListener)) {
                    toolkit = dependenciesPage.getManagedForm().getToolkit();
                    newButton = toolkit != null ? toolkit.createButton(composite3, Messages.ManifestDiscovery_discoverButton_text, 8) : new Button(composite3, 8);
                    newButton.moveAbove((Control)button);
                    composite3.layout();
                    new DiscoverPluginsListener(newButton, dependenciesPage);
                }
                if (!((button = (Button)(composite3 = (Composite)(composite2 = (Composite)(section = (Section)(composite1 = (Composite)layoutComposite.getChildren()[1]).getChildren()[0]).getChildren()[2]).getChildren()[1]).getChildren()[1]).getData() instanceof DiscoverPackagesListener)) {
                    toolkit = dependenciesPage.getManagedForm().getToolkit();
                    newButton = toolkit != null ? toolkit.createButton(composite3, Messages.ManifestDiscovery_discoverButton_text, 8) : new Button(composite3, 8);
                    newButton.moveAbove((Control)button);
                    composite3.layout();
                    new DiscoverPackagesListener(newButton, dependenciesPage);
                }
            }
        }
        catch (Throwable ex) {
            TargletsUIPlugin.INSTANCE.log(ex, 2);
        }
    }

    private void handleTargetDefinition(IWorkbench workbench, ITargetDefinition targetDefinition) {
        targletContainers = this.getTargletContainers(targetDefinition);
        workbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                for (DiscoverListener listener : DISCOVERY_LISTENERS) {
                    listener.updateVisibility();
                }
            }
        });
    }

    private List<ITargletContainer> getTargletContainers(ITargetDefinition targetDefinition) {
        ITargetLocation[] targetLocations;
        ArrayList<ITargletContainer> result = new ArrayList<ITargletContainer>();
        if (targetDefinition != null && (targetLocations = targetDefinition.getTargetLocations()) != null) {
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLocation = iTargetLocationArray[n2];
                if (targetLocation instanceof ITargletContainer) {
                    ITargletContainer targletContainer = (ITargletContainer)targetLocation;
                    result.add(targletContainer);
                }
                ++n2;
            }
        }
        return result;
    }

    private static abstract class DiscoverListener
    extends SelectionAdapter {
        public final GridData gridData = new GridData(770);
        private final Button button;
        protected final String namespace;
        protected final DependenciesPage dependenciesPage;

        public DiscoverListener(Button button, String namespace, DependenciesPage dependenciesPage) {
            this.button = button;
            this.namespace = namespace;
            this.dependenciesPage = dependenciesPage;
            button.setText(Messages.ManifestDiscovery_discoverButton_text);
            button.setLayoutData((Object)this.gridData);
            button.setData((Object)this);
            DISCOVERY_LISTENERS.add(this);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DISCOVERY_LISTENERS.remove((Object)this);
                }
            });
            button.addSelectionListener((SelectionListener)this);
            this.updateVisibility();
        }

        public void updateVisibility() {
            boolean visible = targletContainers != null && !targletContainers.isEmpty();
            this.button.setVisible(visible);
            this.gridData.exclude = !visible;
            this.button.getParent().layout();
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] results;
            ManifestDiscoveryDialog dialog = new ManifestDiscoveryDialog(PDEPlugin.getActiveWorkbenchShell(), this.namespace, targletContainers, true);
            dialog.create();
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length != 0) {
                Requirement[] requirements = new Requirement[results.length];
                int i = 0;
                while (i < results.length) {
                    requirements[i] = (Requirement)results[i];
                    Version version = requirements[i].getVersionRange().getMinimum();
                    if (version != null && !version.equals(Version.emptyVersion)) {
                        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR, true);
                        requirements[i].setVersionRange(versionRange);
                    }
                    ++i;
                }
                this.selected(requirements);
            }
        }

        protected abstract void selected(Requirement[] var1);
    }

    private static final class DiscoverPackagesListener
    extends DiscoverListener {
        public DiscoverPackagesListener(Button button, DependenciesPage dependenciesPage) {
            super(button, "java.package", dependenciesPage);
        }

        @Override
        protected void selected(Requirement[] requirements) {
            Bundle bundle = (Bundle)this.getBundle();
            String versionAttribute = this.getVersionAttribute((IBundle)bundle);
            ImportPackageHeader header = (ImportPackageHeader)bundle.getManifestHeader("Import-Package");
            if (header != null) {
                HashSet<String> names = new HashSet<String>();
                Requirement[] requirementArray = requirements;
                int n = requirements.length;
                int n2 = 0;
                while (n2 < n) {
                    Requirement requirement = requirementArray[n2];
                    String name = requirement.getName();
                    if (names.add(name)) {
                        ImportPackageObject packageImport = new ImportPackageObject((ManifestHeader)header, name, requirement.getVersionRange().toString(), versionAttribute);
                        header.addPackage((PackageObject)packageImport);
                    }
                    ++n2;
                }
            } else {
                bundle.setHeader("Import-Package", this.getValue(requirements, versionAttribute));
            }
        }

        private BundleInputContext getBundleContext() {
            InputContextManager manager = this.dependenciesPage.getPDEEditor().getContextManager();
            return (BundleInputContext)manager.findContext("bundle-context");
        }

        private IBundleModel getBundleModel() {
            BundleInputContext context = this.getBundleContext();
            return context != null ? context.getModel() : null;
        }

        private IBundle getBundle() {
            IBundleModel model = this.getBundleModel();
            return model != null ? model.getBundle() : null;
        }

        private String getVersionAttribute(IBundle bundle) {
            int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle);
            return manifestVersion < 2 ? "specification-version" : "version";
        }

        private String getValue(Object[] requirements, String versionAttribute) {
            StringBuilder builder = new StringBuilder();
            String lineDelimiter = this.getLineDelimiter();
            Object[] objectArray = requirements;
            int n = requirements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (builder.length() > 0) {
                    builder.append(",");
                    builder.append(lineDelimiter);
                    builder.append(" ");
                }
                Requirement requirement = (Requirement)object;
                builder.append(requirement.getName());
                builder.append(";");
                builder.append(versionAttribute);
                builder.append("=\"");
                builder.append(requirement.getVersionRange());
                builder.append("\"");
                ++n2;
            }
            return builder.toString();
        }

        private String getLineDelimiter() {
            BundleInputContext inputContext = this.getBundleContext();
            if (inputContext != null) {
                return inputContext.getLineDelimiter();
            }
            return StringUtil.NL;
        }
    }

    private static final class DiscoverPluginsListener
    extends DiscoverListener {
        public DiscoverPluginsListener(Button button, DependenciesPage dependenciesPage) {
            super(button, "osgi.bundle", dependenciesPage);
        }

        @Override
        protected void selected(Requirement[] requirements) {
            IPluginModelBase model = (IPluginModelBase)this.dependenciesPage.getModel();
            IPluginModelFactory pluginFactory = model.getPluginFactory();
            IPluginImport[] imports = new IPluginImport[requirements.length];
            try {
                int i = 0;
                while (i < requirements.length) {
                    imports[i] = this.createImport(pluginFactory, requirements[i].getName());
                    imports[i].setVersion(requirements[i].getVersionRange().toString());
                    ++i;
                }
                this.addImports(model.getPluginBase(), imports);
            }
            catch (Exception ex) {
                TargletsUIPlugin.INSTANCE.log(ex, 2);
            }
        }

        private IPluginImport createImport(IPluginModelFactory factory, String id) {
            if (factory instanceof AbstractPluginModelBase) {
                return ((AbstractPluginModelBase)factory).createImport(id);
            }
            if (factory instanceof BundlePluginModelBase) {
                return ((BundlePluginModelBase)factory).createImport(id);
            }
            if (factory instanceof PluginDocumentNodeFactory) {
                return ((PluginDocumentNodeFactory)factory).createImport(id);
            }
            return null;
        }

        private void addImports(IPluginBase base, IPluginImport[] imports) throws CoreException {
            if (base instanceof BundlePluginBase) {
                ((BundlePluginBase)base).add(imports);
            } else if (base instanceof PluginBase) {
                ((PluginBase)base).add(imports);
            } else if (base instanceof PluginBaseNode) {
                ((PluginBaseNode)base).add(imports);
            }
        }
    }
}

