/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.stepFilter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilter;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateStepFilterDialog
extends StatusDialog {
    private Text text;
    private DebugStepFilter filter;
    private Button okButton;
    private boolean filterValid;
    private boolean okClicked;
    private DebugStepFilter[] existingFilters;

    private CreateStepFilterDialog(Shell parent, DebugStepFilter filter, DebugStepFilter[] existingFilters) {
        super(parent);
        this.setShellStyle(this.getShellStyle());
        this.filter = filter;
        this.existingFilters = existingFilters;
        this.setTitle(PHPDebugUIMessages.CreateStepFilterDialog_addStepFilter);
        this.setStatusLineAboveButtons(false);
    }

    static DebugStepFilter showCreateStepFilterDialog(Shell parent, DebugStepFilter[] existingFilters) {
        CreateStepFilterDialog createStepFilterDialog = new CreateStepFilterDialog(parent, new DebugStepFilter(9001, true, false, ""), existingFilters);
        createStepFilterDialog.create();
        createStepFilterDialog.open();
        return createStepFilterDialog.filter;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        container.setLayout((Layout)gridLayout);
        int textStyles = 16388;
        Label label = new Label(container, textStyles);
        label.setText(PHPDebugUIMessages.CreateStepFilterDialog_patternToFilter);
        label.setFont(container.getFont());
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.text = new Text(container, textStyles);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 300;
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(container.getFont());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStepFilterDialog.this.validateChange();
                if (!CreateStepFilterDialog.this.filterValid) {
                    CreateStepFilterDialog.this.updateStatus((IStatus)new StatusInfo(4, PHPDebugUIMessages.CreateStepFilterDialog_invalidPathPattern));
                    return;
                }
                if (CreateStepFilterDialog.this.isDuplicateFilter(CreateStepFilterDialog.this.text.getText().trim())) {
                    CreateStepFilterDialog.this.updateStatus((IStatus)new StatusInfo(4, PHPDebugUIMessages.CreateStepFilterDialog_stepFilterAlreadyExists));
                    return;
                }
                CreateStepFilterDialog.this.filterValid = true;
                CreateStepFilterDialog.this.updateStatus((IStatus)new StatusInfo());
            }
        });
        return container;
    }

    private void validateChange() {
        String trimmedValue = this.text.getText().trim();
        if (trimmedValue.length() > 0 && this.validateInput(trimmedValue)) {
            this.okButton.setEnabled(true);
            this.filter.setPath(this.text.getText());
            this.filterValid = true;
        } else {
            this.okButton.setEnabled(false);
            this.filter.setPath("");
            this.filterValid = false;
        }
    }

    private boolean isDuplicateFilter(String trimmedValue) {
        int i = 0;
        while (i < this.existingFilters.length) {
            if (this.existingFilters[i].getPath().equalsIgnoreCase(trimmedValue)) {
                this.okButton.setEnabled(false);
                this.filterValid = false;
                return true;
            }
            ++i;
        }
        this.okButton.setEnabled(true);
        this.filterValid = true;
        return false;
    }

    private boolean validateInput(String trimmedValue) {
        int i = 0;
        while (i < trimmedValue.length()) {
            if (trimmedValue.charAt(i) == '*' && i != 0 && i != trimmedValue.length() - 1) {
                return false;
            }
            if (trimmedValue.charAt(i) == ':' && i != 1) {
                return false;
            }
            ++i;
        }
        Pattern p = Pattern.compile("[[{}]|\"<>\\?]");
        Matcher m = p.matcher(trimmedValue);
        return !m.find();
    }

    public boolean close() {
        if (!this.okClicked) {
            this.filterValid = false;
            this.filter = null;
        }
        return super.close();
    }

    protected void okPressed() {
        this.okClicked = true;
        super.okPressed();
    }
}

