/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.controls.BaseControl;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public class ButtonPanelControl
extends BaseControl {
    private final IManagedForm form;
    private Composite panel;
    Button applyButton;
    private IPropertyListener dirtyListener = null;

    public ButtonPanelControl(IManagedForm form) {
        Assert.isNotNull((Object)form);
        this.form = form;
    }

    protected final IManagedForm getManagedForm() {
        return this.form;
    }

    public void dispose() {
        if (this.dirtyListener != null && this.getEditor() != null) {
            this.getEditor().removePropertyListener(this.dirtyListener);
            this.dirtyListener = null;
        }
        super.dispose();
    }

    public void setupPanel(Composite parent) {
        super.setupPanel(parent);
        this.panel = this.doCreatePanel(parent);
        Assert.isNotNull((Object)this.panel);
        this.doCreateButtons(this.panel);
    }

    protected Composite doCreatePanel(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridData layoutData = new GridData(131072, 1, true, false);
        if (parent.getLayout() instanceof GridLayout) {
            layoutData.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        panel.setLayoutData((Object)layoutData);
        panel.setBackground(parent.getBackground());
        return panel;
    }

    protected boolean hasApplyButton() {
        return true;
    }

    protected void doCreateButtons(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.hasApplyButton() && this.getEditor() != null) {
            this.applyButton = new Button(parent, 8);
            this.applyButton.setText(Messages.ButtonPanelControl_applyButton_label);
            this.applyButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
            this.applyButton.setBackground(parent.getBackground());
            GridData layoutData = new GridData(131072, 0x1000000, false, false);
            layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.applyButton, (int)15);
            this.applyButton.setLayoutData((Object)layoutData);
            this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormEditor editor = ButtonPanelControl.this.getEditor();
                    Assert.isNotNull((Object)editor);
                    if (editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
            this.dirtyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        boolean dirty = ButtonPanelControl.this.getEditor().isDirty();
                        ButtonPanelControl.this.applyButton.setEnabled(dirty);
                    }
                }
            };
            this.getEditor().addPropertyListener(this.dirtyListener);
            this.applyButton.setEnabled(this.getEditor().isDirty());
        }
    }

    protected final FormEditor getEditor() {
        Object container;
        FormEditor editor = null;
        Object object = container = this.getManagedForm() != null ? this.getManagedForm().getContainer() : null;
        if (container instanceof FormEditor) {
            editor = (FormEditor)container;
        } else if (container instanceof FormPage) {
            editor = ((FormPage)container).getEditor();
        }
        return editor;
    }
}

