/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.junitXmlReport;

import java.time.Instant;
import org.eclipse.core.runtime.OperationCanceledException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HistoryEntryHandler
extends DefaultHandler {
    private int failuresAndErrors;
    private Instant startTime;
    private String name;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        if ("testrun".equals(qName)) {
            String attribute = attributes.getValue("errors");
            if (attribute != null) {
                this.failuresAndErrors = this.getFailuresAndErrors() + Integer.parseInt(attribute);
            }
            if ((attribute = attributes.getValue("failures")) != null) {
                this.failuresAndErrors = this.getFailuresAndErrors() + Integer.parseInt(attribute);
            }
            this.name = attributes.getValue("name");
            attribute = attributes.getValue("startTime");
            if (attribute != null) {
                this.startTime = Instant.parse(attribute);
            }
        }
    }

    public int getFailuresAndErrors() {
        return this.failuresAndErrors;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public String getName() {
        return this.name;
    }
}

