/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import java.awt.Container;
import java.beans.Beans;
import java.util.List;
import java.util.Locale;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.SwingContainerWrapper;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

public abstract class MigDimensionInfo {
    protected final MigLayoutInfo m_layout;
    private final boolean m_horizontal;
    protected DimConstraint m_constraint;

    public MigDimensionInfo(MigLayoutInfo layout, boolean horizontal) {
        this.m_layout = layout;
        this.m_horizontal = horizontal;
        this.m_constraint = this.createDefaultConstraint();
    }

    public abstract void delete() throws Exception;

    public abstract List<? extends MigDimensionInfo> getSiblings();

    public final int getIndex() {
        return this.getSiblings().indexOf(this);
    }

    public final String getTooltip() {
        return this.getString(true);
    }

    public final String getString(boolean withBraces) {
        AC ac = new AC();
        ac.setConstaints(new DimConstraint[]{this.m_constraint});
        String constraintString = IDEUtil.getConstraintString((AC)ac, (boolean)false, (boolean)this.m_horizontal);
        if (!withBraces) {
            constraintString = StringUtils.strip((String)constraintString, (String)"[]");
        }
        return constraintString;
    }

    public final void setString(String s) {
        this.m_constraint = MigDimensionInfo.parseDimConstraint(this.m_horizontal, s);
    }

    public final BoundSize getGapBefore() {
        return this.m_constraint.getGapBefore();
    }

    public final void setGapBefore(String boundSizeString) {
        BoundSize gap = this.parseBoundSize(boundSizeString);
        this.m_constraint.setGapBefore(gap);
        List<? extends MigDimensionInfo> siblings = this.getSiblings();
        int index = siblings.indexOf(this);
        if (index != 0) {
            siblings.get((int)(index - 1)).m_constraint.setGapAfter(gap);
        }
    }

    public final BoundSize getGapAfter() {
        return this.m_constraint.getGapAfter();
    }

    public final void setGapAfter(String boundSizeString) {
        BoundSize gap = this.parseBoundSize(boundSizeString);
        this.m_constraint.setGapAfter(gap);
        List<? extends MigDimensionInfo> siblings = this.getSiblings();
        int index = siblings.indexOf(this);
        if (index != siblings.size() - 1) {
            siblings.get((int)(index + 1)).m_constraint.setGapBefore(gap);
        }
    }

    public final int getGrowPriority() {
        return this.m_constraint.getGrowPriority();
    }

    public final void setGrowPriority(int priority) {
        this.m_constraint.setGrowPriority(priority);
    }

    public final Float getGrow() {
        return this.m_constraint.getGrow();
    }

    public final void setGrow(Float weight) {
        this.m_constraint.setGrow(weight);
    }

    public final boolean hasGrow() {
        Float grow = this.m_constraint.getGrow();
        return grow != null && grow.floatValue() > 0.001f;
    }

    public final void flipGrow() {
        if (this.hasGrow()) {
            this.m_constraint.setGrow(null);
        } else {
            this.m_constraint.setGrow(Float.valueOf(100.0f));
        }
    }

    public final int getShrinkPriority() {
        return this.m_constraint.getShrinkPriority();
    }

    public final void setShrinkPriority(int priority) {
        this.m_constraint.setShrinkPriority(priority);
    }

    public final Float getShrink() {
        return this.m_constraint.getShrink();
    }

    public final void setShrink(Float weight) {
        this.m_constraint.setShrink(weight);
    }

    final void updateConstraint() throws Exception {
        this.m_constraint = this.fetchConstraint();
    }

    protected abstract DimConstraint fetchConstraint();

    protected abstract DimConstraint createDefaultConstraint();

    public UnitValue getMinimumSize() {
        BoundSize boundSize = this.m_constraint.getSize();
        return boundSize.getMin();
    }

    public void setMinimumSize(String s) {
        UnitValue size = this.parseSimpleSize(s);
        BoundSize boundSize = this.m_constraint.getSize();
        this.m_constraint.setSize(new BoundSize(size, boundSize.getPreferred(), boundSize.getMax(), null));
    }

    public UnitValue getPreferredSize() {
        BoundSize boundSize = this.m_constraint.getSize();
        return boundSize.getPreferred();
    }

    public void setPreferredSize(String s) {
        UnitValue size = this.parseSimpleSize(s);
        BoundSize boundSize = this.m_constraint.getSize();
        this.m_constraint.setSize(new BoundSize(boundSize.getMin(), size, boundSize.getMax(), null));
    }

    public UnitValue getMaximumSize() {
        BoundSize boundSize = this.m_constraint.getSize();
        return boundSize.getMax();
    }

    public void setMaximumSize(String s) {
        UnitValue size = this.parseSimpleSize(s);
        BoundSize boundSize = this.m_constraint.getSize();
        this.m_constraint.setSize(new BoundSize(boundSize.getMin(), boundSize.getPreferred(), size, null));
    }

    public void setSize(String sizeString) {
        BoundSize size = this.parseBoundSize(sizeString);
        if (size == null) {
            size = new BoundSize(null, null, null, null);
        }
        this.m_constraint.setSize(size);
    }

    private UnitValue parseSimpleSize(String s) {
        BoundSize boundSize = this.parseBoundSize(s);
        return boundSize != null ? boundSize.getPreferred() : null;
    }

    private BoundSize parseBoundSize(String sizeString) {
        if (sizeString == null) {
            return null;
        }
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            BoundSize boundSize = ConstraintParser.parseBoundSize((String)sizeString, (boolean)false, (boolean)this.m_horizontal);
            return boundSize;
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
    }

    public final String getString(UnitValue value) {
        if (value != null) {
            return this.getString(new BoundSize(null, value, null, null));
        }
        return null;
    }

    public final String getString(BoundSize boundSize) {
        if (boundSize != null) {
            AC ac = new AC();
            DimConstraint dimConstraint = new DimConstraint();
            dimConstraint.setSize(boundSize);
            ac.setConstaints(new DimConstraint[]{dimConstraint});
            String constraintString = IDEUtil.getConstraintString((AC)ac, (boolean)false, (boolean)this.m_horizontal);
            return StringUtils.strip((String)constraintString, (String)"[]");
        }
        return null;
    }

    protected static DimConstraint parseDimConstraint(boolean horizontal, String s) {
        AC ac;
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            ac = horizontal ? ConstraintParser.parseColumnConstraints((String)s) : ConstraintParser.parseRowConstraints((String)s);
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
        Assert.equals((int)1, (int)ac.getCount(), (String)s);
        return ac.getConstaints()[0];
    }

    public String toUnitString(int pixels, String unit) {
        return String.format(Locale.ENGLISH, "%.2f%s", Float.valueOf(this.toUnit(pixels, unit)), unit);
    }

    public float toUnit(int pixels, String unit) {
        float pixelsInOne = this.getPixelsInOneUnit(unit);
        return (float)pixels / pixelsInOne;
    }

    public float getPixelsInOneUnit(String unit) {
        UnitValue unitValue = ConstraintParser.parseUnitValue((String)("1" + unit), (boolean)this.m_horizontal);
        Container container = this.m_layout.getContainer().getContainer();
        SwingContainerWrapper parentWrapper = new SwingContainerWrapper(container);
        int refValue = this.m_horizontal ? container.getBounds().width : container.getBounds().height;
        return unitValue.getPixelsExact((float)refValue, (ContainerWrapper)parentWrapper, null);
    }
}

