/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDElementDeclarationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDSchemaCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDElementCommand;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDComponentHelper {
    public static XSDElementDeclaration createAnonymousXSDElementDefinition(String baseName, Part part) {
        XSDElementDeclaration anonElement = XSDComponentHelper.createXSDElementDeclarationCommand(part.getEnclosingDefinition(), baseName, part);
        XSDComplexTypeDefinition newAnon = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle newXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup newXSDModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        newXSDModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        anonElement.setAnonymousTypeDefinition((XSDTypeDefinition)newAnon);
        newXSDParticle.setContent((XSDParticleContent)newXSDModelGroup);
        newAnon.setContent((XSDComplexTypeContent)newXSDParticle);
        return anonElement;
    }

    public static XSDElementDeclaration createXSDElementDeclarationCommand(Definition definition, String baseName, Object context) {
        XSDElementDeclaration xsdElement = null;
        if (context instanceof Part) {
            AddXSDElementDeclarationCommand command = new AddXSDElementDeclarationCommand(definition, "");
            XSDSchema xsdSchema = command.getSchema();
            String name = NameUtil.getXSDElementName(baseName, xsdSchema);
            command.run(name);
            xsdElement = command.getXSDElement();
        } else if (context instanceof XSDModelGroup) {
            XSDModelGroup modelGroup = (XSDModelGroup)context;
            XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
            String name = NameUtil.getXSDElementName(baseName, modelGroup);
            AddXSDElementCommand command = new AddXSDElementCommand(Messages._UI_ACTION_ADD_XML_SCHEMA_ELEMENT, modelGroup);
            command.execute();
            xsdElement = (XSDElementDeclaration)command.getAddedComponent();
            xsdElement.setName(name);
            xsdElement.setTypeDefinition((XSDTypeDefinition)XSDComponentHelper.getXSDStringType((XSDComponent)modelGroup));
            newParticle.setContent((XSDParticleContent)xsdElement);
            modelGroup.getContents().add((Object)newParticle);
        } else {
            AddXSDElementCommand command = new AddXSDElementCommand();
            command.execute();
            xsdElement = (XSDElementDeclaration)command.getAddedComponent();
            xsdElement.setName(baseName);
        }
        return xsdElement;
    }

    public static void addXSDElementToModelGroup(XSDElementDeclaration parent, XSDElementDeclaration child) {
        if (parent.getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition anonType = (XSDComplexTypeDefinition)parent.getAnonymousTypeDefinition();
            if (anonType.getContent() instanceof XSDParticle) {
                XSDParticle particle = (XSDParticle)anonType.getContent();
                if (particle.getContent() instanceof XSDModelGroup) {
                    XSDModelGroup modelGroup = (XSDModelGroup)particle.getContent();
                    XSDComponentHelper.addXSDElementToModelGroup(modelGroup, child);
                } else {
                    XSDComponentHelper.addXSDElementToModelGroup(particle, child);
                }
            } else {
                XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
                anonType.setContent((XSDComplexTypeContent)newParticle);
                XSDComponentHelper.addXSDElementToModelGroup(newParticle, child);
            }
        } else {
            XSDComplexTypeDefinition newAnonType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            parent.setAnonymousTypeDefinition((XSDTypeDefinition)newAnonType);
            XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
            newAnonType.setContent((XSDComplexTypeContent)newParticle);
            XSDComponentHelper.addXSDElementToModelGroup(newParticle, child);
        }
    }

    public static void addXSDElementToModelGroup(XSDParticle particle, XSDElementDeclaration child) {
        XSDModelGroup newXSDModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        newXSDModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        particle.setContent((XSDParticleContent)newXSDModelGroup);
        XSDComponentHelper.addXSDElementToModelGroup(newXSDModelGroup, child);
    }

    public static void addXSDElementToModelGroup(XSDModelGroup modelGroup, XSDElementDeclaration child) {
        XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
        newParticle.setContent((XSDParticleContent)child);
        modelGroup.getContents().add((Object)newParticle);
    }

    public static XSDModelGroup getXSDModelGroup(XSDElementDeclaration xsdElement, Definition definition) {
        XSDModelGroup modelGroup = null;
        XSDComplexTypeDefinition anonType = null;
        if (xsdElement.getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition) {
            anonType = (XSDComplexTypeDefinition)xsdElement.getAnonymousTypeDefinition();
        } else {
            anonType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            anonType.setName("NewComplexTypeName");
            XSDComponentHelper.getXSDSchema(definition).getContents().add((Object)anonType);
            xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)anonType);
        }
        if (anonType != null) {
            modelGroup = XSDComponentHelper.getXSDModelGroup(anonType);
        }
        return modelGroup;
    }

    public static XSDModelGroup getXSDModelGroup(XSDComplexTypeDefinition xsdComplexType) {
        XSDModelGroup modelGroup = null;
        XSDParticle particle = null;
        if (xsdComplexType.getContent() instanceof XSDParticle) {
            particle = (XSDParticle)xsdComplexType.getContent();
        } else {
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            particle.setContent((XSDParticleContent)modelGroup);
            xsdComplexType.setContent((XSDComplexTypeContent)particle);
        }
        if (particle.getContent() instanceof XSDModelGroup) {
            modelGroup = (XSDModelGroup)particle.getContent();
        } else {
            modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            particle.setContent((XSDParticleContent)modelGroup);
        }
        return modelGroup;
    }

    public static XSDComplexTypeDefinition createXSDComplexTypeDefiniion(String complexTypeName, Part part) {
        XSDComplexTypeDefinition newComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle newXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup newXSDModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        newXSDModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        newComplexType.setName(complexTypeName);
        newComplexType.setContent((XSDComplexTypeContent)newXSDParticle);
        newXSDParticle.setContent((XSDParticleContent)newXSDModelGroup);
        XSDComponentHelper.getXSDSchema(part.getEnclosingDefinition()).getContents().add((Object)newComplexType);
        return newComplexType;
    }

    public static void addXSDElementToModelGroup(XSDComplexTypeDefinition parent, XSDElementDeclaration child) {
        if (parent.getContent() instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)parent.getContent();
            if (particle.getContent() instanceof XSDModelGroup) {
                XSDModelGroup modelGroup = (XSDModelGroup)particle.getContent();
                XSDComponentHelper.addXSDElementToModelGroup(modelGroup, child);
            } else {
                XSDComponentHelper.addXSDElementToModelGroup(particle, child);
            }
        } else {
            XSDParticle newParticle = XSDFactory.eINSTANCE.createXSDParticle();
            parent.setContent((XSDComplexTypeContent)newParticle);
            XSDComponentHelper.addXSDElementToModelGroup(newParticle, child);
        }
    }

    public static XSDSchema getXSDSchema(Definition definition) {
        XSDSchema schema = null;
        String wsdlTargetNamespace = definition.getTargetNamespace();
        Types types = (Types)definition.getTypes();
        if (types != null) {
            for (Object eeElement : types.getExtensibilityElements()) {
                XSDSchemaExtensibilityElement ee;
                if (!(eeElement instanceof XSDSchemaExtensibilityElement) || (ee = (XSDSchemaExtensibilityElement)eeElement).getSchema().getTargetNamespace() == null || !ee.getSchema().getTargetNamespace().equals(wsdlTargetNamespace)) continue;
                schema = ee.getSchema();
                break;
            }
        }
        if (schema == null) {
            Object eeElement;
            AddXSDSchemaCommand command = new AddXSDSchemaCommand(definition);
            command.run();
            eeElement = (XSDSchemaExtensibilityElement)command.getWSDLElement();
            schema = eeElement.getSchema();
        }
        return schema;
    }

    private static XSDSimpleTypeDefinition getXSDStringType(XSDComponent component) {
        XSDSchema schema = component.getSchema();
        return schema.getSchemaForSchema().resolveSimpleTypeDefinition("string");
    }
}

