/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.controller;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.controller.IPackageCheckStateChangedListener;
import org.eclipse.swt.graphics.Image;

public class PackageController
extends StyledCellLabelProvider
implements IStructuredContentProvider,
ICheckStateProvider,
ICheckStateListener {
    private List<MinimalPackage> packages;
    private List<String> checked = new ArrayList<String>();
    protected static Image pkgImage = ComposerUIPluginImages.PACKAGE.createImage();
    protected static Image phpImage = ComposerUIPluginImages.PHP.createImage();
    protected List<IPackageCheckStateChangedListener> pkgListeners = new ArrayList<IPackageCheckStateChangedListener>();

    public void addPackageCheckStateChangedListener(IPackageCheckStateChangedListener listener) {
        if (!this.pkgListeners.contains(listener)) {
            this.pkgListeners.add(listener);
        }
    }

    public void removePackageCheckStateChangedListener(IPackageCheckStateChangedListener listener) {
        this.pkgListeners.remove(listener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.packages = newInput == null ? null : (List)newInput;
    }

    public Object[] getElements(Object inputElement) {
        if (this.packages != null) {
            return this.packages.toArray();
        }
        return null;
    }

    public void addPackages(List<MinimalPackage> packages) {
        this.packages.addAll(packages);
    }

    public Image getImage(Object element) {
        return PackageController.getPackageImage(element);
    }

    public static Image getPackageImage(Object element) {
        String name = PackageController.getPackageName(element);
        if (!name.contains("/") && (name.equals("php") || name.startsWith("ext-"))) {
            return phpImage;
        }
        return pkgImage;
    }

    public String getText(Object element) {
        return this.getName(element);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.setChecked(((MinimalPackage)event.getElement()).getName(), event.getChecked());
    }

    public List<String> getCheckedPackages() {
        return this.checked;
    }

    public int getCheckedPackagesCount() {
        return this.checked.size();
    }

    public void clear() {
        this.checked.clear();
    }

    public void setChecked(String name, boolean checked) {
        if (checked && !this.checked.contains(name)) {
            this.checked.add(name);
        }
        if (!checked) {
            this.checked.remove(name);
        }
        for (IPackageCheckStateChangedListener listener : this.pkgListeners) {
            listener.packageCheckStateChanged(name, checked);
        }
    }

    private String getName(Object element) {
        return PackageController.getPackageName(element);
    }

    public static String getPackageName(Object element) {
        String name = null;
        if (element instanceof MinimalPackage) {
            name = ((MinimalPackage)element).getName();
        } else if (element instanceof String) {
            name = (String)element;
        }
        return name;
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        if (obj instanceof MinimalPackage) {
            MinimalPackage pkg = (MinimalPackage)obj;
            StyledString styledString = new StyledString();
            this.updateText(pkg, styledString);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(pkg));
            super.update(cell);
        }
    }

    protected void updateText(MinimalPackage pkg, StyledString styledString) {
        styledString.append(this.getName(pkg));
    }

    public boolean isChecked(Object element) {
        return this.checked.contains(this.getName(element));
    }

    public boolean isGrayed(Object element) {
        return false;
    }
}

