/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.InvalidExpressionVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class SingleExpressionVMNode
extends AbstractVMNode
implements IElementLabelProvider {
    public SingleExpressionVMNode(ExpressionVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "SingleExpressionVMNode";
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    private IExpressions.IExpressionDMContext getUpdateExpressionDMC(IViewerUpdate update) {
        IDMContext dmc;
        if (update.getElement() instanceof IDMVMContext && (dmc = ((IDMVMContext)update.getElement()).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
            return (IExpressions.IExpressionDMContext)dmc;
        }
        return null;
    }

    public void update(IHasChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            updates[i].setHasChilren(this.getUpdateExpressionDMC((IViewerUpdate)updates[i]) != null);
            updates[i].done();
            ++i;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                update.setChildCount(this.getUpdateExpressionDMC((IViewerUpdate)update) != null ? 1 : 0);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            IExpressions.IExpressionDMContext dmc = this.getUpdateExpressionDMC((IViewerUpdate)update);
            if (dmc != null) {
                this.doUpdateChildren(update, new SimpleExpression(dmc.getExpression()));
            } else {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
            ++n2;
        }
    }

    public void doUpdateChildren(final IChildrenUpdate update, final IExpression expression) {
        ((ExpressionVMProvider)this.getVMProvider()).update(new VMExpressionUpdate((IViewerUpdate)update, expression, (DataRequestMonitor<Object>)new ViewerDataRequestMonitor<Object>(this.getVMProvider().getExecutor(), (IViewerUpdate)update){

            @Override
            protected void handleSuccess() {
                update.setChild(this.getData(), 0);
                update.done();
            }

            protected void handleError() {
                update.setChild((Object)new InvalidExpressionVMContext(SingleExpressionVMNode.this, expression), 0);
                update.done();
            }
        }));
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            update.done();
            ++n2;
        }
    }

    @Override
    public int getDeltaFlags(Object event) {
        int retVal = 0;
        if (event instanceof ExpressionsChangedEvent) {
            retVal |= 0x413;
        }
        IExpressionVMNode[] iExpressionVMNodeArray = this.getExpressionVMProvider().getExpressionNodes();
        int n = iExpressionVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpressionVMNode node = iExpressionVMNodeArray[n2];
            retVal |= this.getDeltaFlagsForNode(node, event);
            ++n2;
        }
        return retVal;
    }

    private int getDeltaFlagsForNode(IVMNode node, Object event) {
        int retVal = node.getDeltaFlags(event);
        IVMNode[] iVMNodeArray = this.getVMProvider().getChildVMNodes(node);
        int n = iVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode child = iVMNodeArray[n2];
            if (!node.equals(child)) {
                retVal |= this.getDeltaFlagsForNode(child, event);
            }
            ++n2;
        }
        return retVal;
    }

    @Override
    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ExpressionsChangedEvent) {
            this.buildDeltaForExpressionsChangedEvent((ExpressionsChangedEvent)event, parentDelta, nodeOffset, requestMonitor);
        } else {
            IDMContext dmc;
            Object parent = parentDelta.getElement();
            if (parent instanceof IDMVMContext && (dmc = ((IDMVMContext)parent).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
                SimpleExpression expression = new SimpleExpression(((IExpressions.IExpressionDMContext)dmc).getExpression());
                int flags = this.getExpressionVMProvider().getDeltaFlagsForExpression(expression, event);
                if (flags != 0) {
                    this.getExpressionVMProvider().buildDeltaForExpression(expression, nodeOffset, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), requestMonitor);
                    return;
                }
            }
            requestMonitor.done();
        }
    }

    private void buildDeltaForExpressionsChangedEvent(ExpressionsChangedEvent event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
        int i = 0;
        while (i < event.getExpressions().length) {
            int expIndex = event.getIndex() != -1 ? nodeOffset + event.getIndex() + i : -1;
            this.getExpressionVMProvider().buildDeltaForExpression(event.getExpressions()[i], expIndex, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
            ++i;
        }
        multiRm.setDoneCount(event.getExpressions().length);
    }

    private TreePath getTreePathFromDelta(IModelDelta delta) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            elementList.add(0, listDelta.getElement());
            listDelta = listDelta.getParentDelta();
        }
        return new TreePath(elementList.toArray());
    }

    public IDMVMContext createVMContext(IDMContext dmc) {
        return new RootDMVMContext(this.getVMProvider().getRootVMNode(), dmc);
    }

    private static class RootDMVMContext
    extends AbstractVMContext
    implements IDMVMContext {
        private final IDMContext fDmc;

        public RootDMVMContext(IVMNode node, IDMContext dmc) {
            super(node);
            this.fDmc = dmc;
        }

        @Override
        public IDMContext getDMContext() {
            return this.fDmc;
        }

        @Override
        public <T> T getAdapter(Class<T> adapter) {
            T superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDmc)) {
                return (T)this.fDmc;
            }
            return (T)this.fDmc.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof RootDMVMContext) {
                RootDMVMContext otherVmc = (RootDMVMContext)other;
                return this.getVMNode().equals(otherVmc.getVMNode()) && this.fDmc.equals(otherVmc.fDmc);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getVMNode().hashCode() + this.fDmc.hashCode();
        }

        public String toString() {
            return this.fDmc.toString();
        }
    }

    private static class SimpleExpression
    implements IExpression {
        private String fExpressionText;

        SimpleExpression(String text) {
            this.fExpressionText = text;
        }

        public void dispose() {
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public String getExpressionText() {
            return this.fExpressionText;
        }

        public IValue getValue() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SimpleExpression) {
                return this.fExpressionText.equals(((SimpleExpression)obj).getExpressionText());
            }
            return false;
        }

        public int hashCode() {
            return this.fExpressionText.hashCode();
        }
    }
}

