/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.IConfigManager;
import org.eclipse.cdt.ui.newui.ManageConfigDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ManageConfigRunner
implements IConfigManager {
    private static final String MANAGE_TITLE = Messages.ManageConfigDialog_0;
    protected static ManageConfigRunner instance = null;
    private ICProjectDescription des = null;
    private IProject prj = null;

    public static ManageConfigRunner getDefault() {
        if (instance == null) {
            instance = new ManageConfigRunner();
        }
        return instance;
    }

    @Override
    public boolean canManage(IProject[] obs) {
        return obs != null && obs.length == 1;
    }

    @Override
    public boolean manage(IProject[] obs, boolean doOk) {
        if (!this.canManage(obs)) {
            return false;
        }
        ManageConfigDialog d = new ManageConfigDialog(Display.getDefault().getActiveShell(), obs[0].getName() + ": " + MANAGE_TITLE, obs[0]);
        boolean result = false;
        if (d.open() == 0) {
            if (doOk) {
                this.des = d.getProjectDescription();
                this.prj = obs[0];
                if (this.des != null) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(false, false, this.getRunnable());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            AbstractPage.updateViews((IResource)obs[0]);
            result = true;
        } else if (doOk) {
            CDTPropertyManager.performCancel(d.getShell());
        }
        return result;
    }

    public IRunnableWithProgress getRunnable() {
        return new WorkspaceModifyDelegatingOperation(imonitor -> CUIPlugin.getDefault().getShell().getDisplay().syncExec(() -> {
            try {
                CoreModel.getDefault().setProjectDescription(this.prj, this.des);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }));
    }
}

