/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model.binary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.model.binary.BinaryField;
import org.eclipse.dltk.core.model.binary.BinaryMember;
import org.eclipse.dltk.core.model.binary.BinaryMethod;
import org.eclipse.dltk.core.model.binary.BinaryTypeElementInfo;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchyBuilders;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.utils.CorePrinter;

public class BinaryType
extends BinaryMember
implements IType,
IParent {
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IMethod[] NO_METHODS = new IMethod[0];
    private static final IType[] NO_TYPES = new IType[0];

    public BinaryType(ModelElement parent, String name) {
        super(parent, name);
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor) throws ModelException {
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
    }

    private IDLTKSearchScope createReferencingProjectsScope() {
        IScriptProject scriptProject = this.getScriptProject();
        IProject project = scriptProject.getProject();
        IProject[] referencingProjects = project.getReferencingProjects();
        ArrayList<IScriptProject> scriptProjects = new ArrayList<IScriptProject>(referencingProjects.length + 1);
        scriptProjects.add(scriptProject);
        int i = 0;
        while (i < referencingProjects.length) {
            IProject p = referencingProjects[i];
            if (p.isAccessible()) {
                scriptProjects.add(DLTKCore.create(p));
            }
            ++i;
        }
        return SearchEngine.createSearchScope(scriptProjects.toArray(new IModelElement[scriptProjects.size()]), false, DLTKLanguageManager.getLanguageToolkit(this));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryType)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public IMethod[] findMethods(IMethod method) {
        try {
            return BinaryType.findMethods(method, this.getMethods());
        }
        catch (ModelException e) {
            return null;
        }
    }

    @Override
    public int getElementType() {
        return 7;
    }

    @Override
    public IField getField(String name) {
        return new BinaryField(this, name);
    }

    @Override
    public IField[] getFields() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName("$");
    }

    @Override
    public String getFullyQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException e) {
            return null;
        }
    }

    @Override
    public IMethod getMethod(String name) {
        return new BinaryMethod(this, name);
    }

    @Override
    public IMethod[] getMethods() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IMethod[] array = new IMethod[size];
        list.toArray(array);
        return array;
    }

    @Override
    public IScriptFolder getScriptFolder() {
        return (IScriptFolder)this.getAncestor(4);
    }

    @Override
    public String[] getSuperClasses() throws ModelException {
        return ((BinaryTypeElementInfo)this.getElementInfo()).getSuperclassNames();
    }

    @Override
    public IType getType(String name) {
        block4: {
            try {
                IType[] types;
                IType[] iTypeArray = types = this.getTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (type.getElementName().equals(name)) {
                        return type;
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName("$");
    }

    @Override
    public String getTypeQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException e) {
            return null;
        }
    }

    @Override
    public IType[] getTypes() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(7);
        int size = list.size();
        if (size == 0) {
            return NO_TYPES;
        }
        IType[] array = new IType[size];
        list.toArray(array);
        return array;
    }

    @Override
    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws ModelException {
        return this.loadTypeHierachy(input, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        return TypeHierarchy.load(this, input, owner);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws ModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(ISourceModule[] workingCopies, IProgressMonitor monitor) throws ModelException {
        IScriptProject scriptProject = this.getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope(scriptProject);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, scope, false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        IScriptProject scriptProject = this.getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope(scriptProject);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, scope, false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws ModelException {
        ITypeHierarchy hierarchy = TypeHierarchyBuilders.getTypeHierarchy(this, ITypeHierarchy.Mode.HIERARCHY, monitor);
        if (hierarchy != null) {
            return hierarchy;
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, this.createReferencingProjectsScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IScriptProject project, IProgressMonitor monitor) throws ModelException {
        return this.newTypeHierarchy(project, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IScriptProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        if (project == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        ISourceModule[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new ISourceModule[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                ISourceModule wc = workingCopies[i];
                if (project.equals(wc.getScriptProject())) {
                    projectWCs[index++] = wc;
                }
                ++i;
            }
            if (index != length) {
                ISourceModule[] iSourceModuleArray = projectWCs;
                projectWCs = new ISourceModule[index];
                System.arraycopy(iSourceModuleArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(ISourceModule[] workingCopies, IProgressMonitor monitor) throws ModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, this.createReferencingProjectsScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, this.createReferencingProjectsScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Binary Type:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + String.valueOf(element));
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }
}

