/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.processing;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;

public abstract class JobManager
implements Runnable {
    private static final boolean ENABLE_DELAYS = Runtime.getRuntime().availableProcessors() == 1;
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    private int enableCount = 1;
    public static final boolean VERBOSE = false;
    public boolean activated = false;
    private final AtomicInteger awaitingClients = new AtomicInteger();
    private final Object delaySignal = new Object();

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public void disable() {
        --this.enableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (i <= this.jobEnd) {
                    currentJob = this.awaitingJobs[i];
                    if (currentJob != null) {
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            currentJob.cancel();
                        }
                    }
                    ++i;
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            this.enable();
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob request) {
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    protected void notifyIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor monitor) {
        boolean status = false;
        searchJob.ensureReadyToRun();
        try {
            SubMonitor subMonitor;
            block25: {
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                if (this.awaitingJobsCount() <= 0) break block25;
                switch (waitingPolicy) {
                    case 1: {
                        try {
                            this.disable();
                            status = searchJob.execute((IProgressMonitor)subMonitor);
                        }
                        finally {
                            this.enable();
                        }
                        boolean bl = status;
                        return bl;
                    }
                    case 2: {
                        throw new OperationCanceledException();
                    }
                    case 3: {
                        SubMonitor subProgress = subMonitor.setWorkRemaining(10).split(8).setWorkRemaining(1000);
                        Object object = this.delaySignal;
                        synchronized (object) {
                            this.delaySignal.notify();
                        }
                        Thread t = this.processingThread;
                        int originalPriority = t == null ? -1 : t.getPriority();
                        try {
                            int awaitingWork;
                            if (t != null) {
                                t.setPriority(Thread.currentThread().getPriority());
                            }
                            this.awaitingClients.incrementAndGet();
                            IJob previousJob = null;
                            while ((awaitingWork = this.awaitingJobsCount()) > 0) {
                                if (subProgress != null && subProgress.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                IJob currentJob = this.currentJob();
                                if (currentJob != null && currentJob != previousJob) {
                                    subProgress.subTask(NLS.bind((String)Messages.manager_filesToIndex, (Object)Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                    previousJob = currentJob;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            this.awaitingClients.decrementAndGet();
                            if (t != null && originalPriority > -1 && t.isAlive()) {
                                t.setPriority(originalPriority);
                            }
                            throw throwable;
                        }
                        this.awaitingClients.decrementAndGet();
                        if (t == null || originalPriority <= -1 || !t.isAlive()) break;
                        t.setPriority(originalPriority);
                    }
                }
            }
            status = searchJob.execute((IProgressMonitor)subMonitor);
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
        return status;
    }

    public abstract String processName();

    public void waitUntilReady() {
        this.performConcurrentJob(new WaitJob(), 3, null);
    }

    public void requestIfNotWaiting(IJob job) {
        if (!this.isJobWaiting(job)) {
            this.request(job);
        }
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            while (true) {
                if (this.processingThread == null) {
                    return;
                }
                try {
                    IJob job;
                    Object object = this;
                    synchronized (object) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        job = this.currentJob();
                        if (job == null) {
                            if (idlingStart < 0L) {
                                idlingStart = System.currentTimeMillis();
                                this.notifyIdle();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            }
                            this.wait();
                        } else {
                            idlingStart = -1L;
                        }
                    }
                    if (job == null) {
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        object = this.delaySignal;
                        synchronized (object) {
                            this.delaySignal.wait(50L);
                            continue;
                        }
                    }
                    try {
                        this.executing = true;
                        job.execute(null);
                        continue;
                    }
                    finally {
                        this.executing = false;
                        this.moveToNextJob();
                        if (ENABLE_DELAYS && this.awaitingClients.get() == 0) {
                            Thread.sleep(50L);
                        }
                    }
                }
                catch (InterruptedException job) {
                    // empty catch block
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread == null) throw e;
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            Util.log(e, "Background Indexer Crash Recovery");
            throw e;
        }
        catch (Error e) {
            if (this.processingThread == null) throw e;
            if (e instanceof ThreadDeath) throw e;
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            Util.log(e, "Background Indexer Crash Recovery");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block5: {
            this.disable();
            this.discardJobs(null);
            Thread thread = this.processingThread;
            try {
                if (thread == null) break block5;
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private static final class WaitJob
    implements IJob {
        private WaitJob() {
        }

        @Override
        public boolean belongsTo(String jobFamily) {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void ensureReadyToRun() {
        }

        @Override
        public boolean execute(IProgressMonitor progress) {
            return false;
        }

        public String toString() {
            return "WAIT-UNTIL-READY-JOB";
        }
    }
}

