/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;
import org.eclipse.pde.internal.ui.views.dependencies.HistoryAction;
import org.eclipse.pde.internal.ui.views.dependencies.HistoryListAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private Menu fMenu;
    private final DependenciesView fView;

    public HistoryDropDownAction(DependenciesView view) {
        this.fView = view;
        this.fMenu = null;
        this.setToolTipText(PDEUIMessages.HistoryDropDownAction_tooltip);
        this.setImageDescriptor(PDEPluginImages.DESC_HISTORY_LIST);
        this.setMenuCreator(this);
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private boolean addEntries(Menu menu, String[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fView, elements[i]);
            action.setChecked(elements[i].equals(this.fView.getInput()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        String[] elements = this.fView.getHistoryEntries();
        boolean checked = this.addEntries(this.fMenu, elements);
        if (elements.length > 10) {
            new MenuItem(this.fMenu, 2);
            HistoryListAction others = new HistoryListAction(this.fView);
            others.setChecked(checked);
            this.addActionToMenu(this.fMenu, others);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        new HistoryListAction(this.fView).run();
    }
}

