/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.function;

import org.eclipse.core.runtime.Assert;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;

public class ParameterInfo {
    public static final int INDEX_FOR_ADDED = -1;
    public static final String ELLIPSIS = "...";
    private IVariableBinding fOldBinding;
    private final String fOldName;
    private final int fOldIndex;
    private String fNewTypeName;
    private ITypeBinding fNewTypeBinding;
    private String fDefaultValue;
    private String fNewName;
    private boolean fIsDeleted;
    private boolean fCreateField = true;
    private boolean fInlined;
    private boolean fResolve = true;

    public ParameterInfo(String name, int index) {
        this(null, name, index);
    }

    public ParameterInfo(IVariableBinding binding, String name, int index) {
        this.fOldBinding = binding;
        this.fOldName = name;
        this.fNewName = name;
        this.fOldIndex = index;
        this.fDefaultValue = "";
        this.fIsDeleted = false;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name) {
        ParameterInfo info = new ParameterInfo("", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setResolve(false);
        return info;
    }

    private void setResolve(boolean resolve) {
        this.fResolve = resolve;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name, String defaultValue) {
        ParameterInfo info = new ParameterInfo("", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        return info;
    }

    public static ParameterInfo createInfoForAddedParameter(ITypeBinding typeBinding, String type, String name, String defaultValue) {
        ParameterInfo info = new ParameterInfo(null, "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        return info;
    }

    public int getOldIndex() {
        return this.fOldIndex;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fIsDeleted = true;
    }

    public boolean isAdded() {
        return this.fOldIndex == -1;
    }

    public boolean isRenamed() {
        return !this.fOldName.equals(this.fNewName);
    }

    public IVariableBinding getOldBinding() {
        return this.fOldBinding;
    }

    public void setNewTypeName(String type) {
        Assert.isNotNull((Object)type);
        this.fNewTypeName = type;
    }

    public ITypeBinding getNewTypeBinding() {
        return this.fNewTypeBinding;
    }

    public void setNewTypeBinding(ITypeBinding typeBinding) {
        this.fNewTypeBinding = typeBinding;
    }

    public boolean isNewVarargs() {
        return ParameterInfo.isVarargs(this.fNewTypeName);
    }

    public String getOldName() {
        return this.fOldName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getOldDisplayName() {
        if (this.fOldName != null && this.fOldName.startsWith("$")) {
            return this.fOldName.substring(1);
        }
        return this.fOldName;
    }

    public String getNewDisplayName() {
        if (this.fNewName != null && this.fNewName.startsWith("$")) {
            return this.fNewName.substring(1);
        }
        return this.fNewName;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName != null && !newName.startsWith("$") ? "$" + newName : newName;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String value) {
        Assert.isNotNull((Object)value);
        this.fDefaultValue = value;
    }

    public String toString() {
        return this.fOldName + " @" + this.fOldIndex + " -> " + this.fNewTypeName + " " + this.fNewName + ": " + this.fDefaultValue + (this.fIsDeleted ? " (deleted)" : " (stays)");
    }

    public static String stripEllipsis(String typeName) {
        if (ParameterInfo.isVarargs(typeName)) {
            return typeName.substring(0, typeName.length() - 3);
        }
        return typeName;
    }

    public static boolean isVarargs(String typeName) {
        return typeName.endsWith(ELLIPSIS);
    }

    public boolean isCreateField() {
        return this.fCreateField;
    }

    public void setCreateField(boolean createField) {
        this.fIsDeleted = createField;
        this.fCreateField = createField;
    }

    public void setOldBinding(IVariableBinding binding) {
        this.fOldBinding = binding;
    }

    public void setInlined(boolean inlined) {
        this.fInlined = inlined;
    }

    public boolean isInlined() {
        return this.fInlined;
    }

    public boolean isResolve() {
        return this.fResolve;
    }
}

