/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ParentOperandFinder;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class Gate
extends AbstractSequenceNode {
    public static final int VISUAL_ID = 3012;

    Gate(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)Gate.notationPredicate().apply((Object)node), (Object)Messages.Gate_nonGateNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 3012, Gate.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public ISequenceElement getHierarchicalParent() {
        View parentView;
        Option<ISequenceNode> parentElement;
        ISequenceElement hierarchicalParent;
        if (CacheHelper.isStructuralCacheEnabled() && (hierarchicalParent = (ISequenceElement)CacheHelper.getGateToHierarchicalParentCache().get(this)) != null) {
            return hierarchicalParent;
        }
        EObject viewContainer = this.view.eContainer();
        if (viewContainer instanceof View && (parentElement = ISequenceElementAccessor.getISequenceNode(parentView = (View)viewContainer)).some()) {
            if (CacheHelper.isStructuralCacheEnabled()) {
                CacheHelper.getGateToHierarchicalParentCache().put(this, (ISequenceNode)parentElement.get());
            }
            return (ISequenceElement)parentElement.get();
        }
        throw new RuntimeException(MessageFormat.format(Messages.Gate_invalidGateContext, this));
    }

    public Option<Message> getMessage() {
        Message msg = null;
        Node node = this.getNotationNode();
        Iterable srcEdges = Iterables.filter((Iterable)node.getSourceEdges(), Edge.class);
        Iterable tgtEdges = Iterables.filter((Iterable)node.getTargetEdges(), Edge.class);
        for (Edge edge : Iterables.concat((Iterable)srcEdges, (Iterable)tgtEdges)) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
            if (!message.some()) continue;
            msg = (Message)message.get();
            break;
        }
        return Options.newSome(msg);
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        Rectangle parentBounds = this.getHierarchicalParent().getProperLogicalBounds();
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            return new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight()).getTranslated(parentBounds.getLocation());
        }
        throw new RuntimeException();
    }

    public Option<Operand> getSiblingOperand() {
        Option siblingOperand = Options.newNone();
        ISequenceElement parent = this.getHierarchicalParent();
        if (parent instanceof CombinedFragment) {
            CombinedFragment cf = (CombinedFragment)parent;
            int gateCenter = this.getProperLogicalBounds().getCenter().y;
            Optional<Operand> found = cf.getOperands().stream().filter(op -> op.getVerticalRange().includes(gateCenter)).findFirst();
            if (found.isPresent()) {
                siblingOperand = Options.fromNullable((Object)found.get());
            }
        }
        return siblingOperand;
    }

    public Option<Operand> getParentOperand() {
        Option<Operand> parentOperand = Options.newNone();
        ISequenceElement parent = this.getHierarchicalParent();
        if (parent instanceof AbstractFrame) {
            AbstractFrame frame = (AbstractFrame)parent;
            Collection<Lifeline> lifelines = frame.computeCoveredLifelines();
            if (lifelines.isEmpty()) {
                parentOperand = frame.getParentOperand();
            } else {
                int frameTop = frame.getProperLogicalBounds().y;
                parentOperand = new ParentOperandFinder(lifelines.iterator().next()).getParentOperand(new Range(frameTop, frameTop));
            }
        }
        return parentOperand;
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getGateMapping()) && !InstanceRole.viewpointElementPredicate().apply((Object)((DDiagramElement)input.eContainer()));
        }
    }
}

