/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.unittest.internal.junitXmlReport.TestRunHandler;
import org.eclipse.unittest.internal.model.ITestRunSessionListener;
import org.eclipse.unittest.internal.model.ModelMessages;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.model.ITestRunSession;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class UnitTestModel {
    private final ListenerList<ITestRunSessionListener> fTestRunSessionListeners = new ListenerList();
    private final LinkedList<TestRunSession> fTestRunSessions = new LinkedList();
    private static UnitTestModel INSTANCE = null;

    private UnitTestModel() {
    }

    public static synchronized UnitTestModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UnitTestModel();
        }
        return INSTANCE;
    }

    public void start() {
    }

    public void stop() {
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public synchronized List<TestRunSession> getTestRunSessions() {
        return new ArrayList<TestRunSession>(this.fTestRunSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        ArrayList<TestRunSession> toRemove = new ArrayList<TestRunSession>();
        UnitTestModel unitTestModel = this;
        synchronized (unitTestModel) {
            Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
            this.fTestRunSessions.addFirst(testRunSession);
            int maxCount = Platform.getPreferencesService().getInt("org.eclipse.unittest.ui", "org.eclipse.unittest.ui.max_test_runs", 10, null);
            int size = this.fTestRunSessions.size();
            if (size > maxCount) {
                List excess = this.fTestRunSessions.subList(maxCount, size);
                Iterator iter = excess.iterator();
                while (iter.hasNext()) {
                    TestRunSession oldSession = (TestRunSession)iter.next();
                    if (!oldSession.isStopped()) continue;
                    toRemove.add(oldSession);
                    iter.remove();
                }
            }
        }
        toRemove.forEach(this::notifyTestRunSessionRemoved);
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public ITestRunSession importTestRunSession(String url, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(ModelMessages.UnitTestModel_importing_from_url, -1);
        final String trimmedUrl = url.trim().replaceAll("\r\n?|\n", "");
        final TestRunHandler handler = new TestRunHandler(monitor);
        final CoreException[] exception = new CoreException[1];
        final TestRunSession[] session = new TestRunSession[1];
        Thread importThread = new Thread("UnitTest URL importer"){

            @Override
            public void run() {
                try {
                    SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
                    parser.parse(trimmedUrl, (DefaultHandler)handler);
                    session[0] = handler.getTestRunSession();
                }
                catch (OperationCanceledException parser) {
                }
                catch (ParserConfigurationException e) {
                    this.storeImportError(e);
                }
                catch (SAXException e) {
                    this.storeImportError(e);
                }
                catch (IOException e) {
                    this.storeImportError(e);
                }
                catch (IllegalArgumentException e) {
                    this.storeImportError(e);
                }
            }

            private void storeImportError(Exception e) {
                exception[0] = new CoreException((IStatus)new Status(4, "org.eclipse.unittest.ui", ModelMessages.UnitTestModel_could_not_import, (Throwable)e));
            }
        };
        importThread.start();
        while (session[0] == null && exception[0] == null && !monitor.isCanceled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session[0] == null) {
            if (exception[0] != null) {
                throw new InvocationTargetException(exception[0]);
            }
            importThread.interrupt();
            throw new InterruptedException();
        }
        this.addTestRunSession(session[0]);
        monitor.done();
        return session[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed;
        UnitTestModel unitTestModel = this;
        synchronized (unitTestModel) {
            existed = this.fTestRunSessions.remove(testRunSession);
        }
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        for (ITestRunSessionListener listener : this.fTestRunSessionListeners) {
            listener.sessionRemoved(testRunSession);
        }
    }

    private void notifyTestRunSessionAdded(ITestRunSession testRunSession) {
        for (ITestRunSessionListener listener : this.fTestRunSessionListeners) {
            listener.sessionAdded(testRunSession);
        }
    }
}

