/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.property.editor.font.AbstractFontPage;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontDialog;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;

public final class JFaceFontPage
extends AbstractFontPage {
    public static final String NAME = "JFace";
    private final Table m_fontTable;
    private final List<FontInfo> m_fonts;

    public JFaceFontPage(Composite parent, int style, FontDialog fontDialog, JavaInfo javaInfo) {
        super(parent, style, fontDialog);
        List<FontInfo> fonts;
        GridLayoutFactory.create((Composite)this);
        new Label((Composite)this, 0).setText(ModelMessages.JFaceFontPage_selectFont);
        this.m_fontTable = new Table((Composite)this, 67584);
        GridDataFactory.create((Control)this.m_fontTable).hintVC(15).grab().fill();
        this.m_fontTable.setHeaderVisible(true);
        this.m_fontTable.setLinesVisible(true);
        new TableColumn(this.m_fontTable, 0).setText(ModelMessages.JFaceFontPage_nameColumn);
        new TableColumn(this.m_fontTable, 0).setText(ModelMessages.JFaceFontPage_valueColumn);
        try {
            fonts = JFaceFontPage.getJFaceFonts();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            fonts = Collections.emptyList();
        }
        this.m_fonts = fonts;
        for (FontInfo fontInfo : this.m_fonts) {
            TableItem tableItem = new TableItem(this.m_fontTable, 0);
            tableItem.setText(0, fontInfo.getName());
            try {
                FontData fontData = fontInfo.getFont().getFontData()[0];
                tableItem.setText(1, fontData.getName() + " " + fontData.getHeight());
            }
            catch (Throwable e) {
                tableItem.setText(1, "???");
            }
        }
        int i = 0;
        while (i < this.m_fontTable.getColumnCount()) {
            this.m_fontTable.getColumn(i).pack();
            ++i;
        }
        this.m_fontTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FontInfo fontInfo = JFaceFontPage.this.m_fonts.get(JFaceFontPage.this.m_fontTable.getSelectionIndex());
                JFaceFontPage.this.m_fontDialog.setFontInfo(fontInfo);
            }
        });
        this.m_fontTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                JFaceFontPage.this.m_fontDialog.closeOk();
            }
        });
    }

    @Override
    public void setFont(FontInfo fontInfo) {
    }

    public static List<FontInfo> getJFaceFonts() throws Exception {
        ArrayList<FontInfo> jfaceFonts = new ArrayList<FontInfo>();
        Method[] methods = JFaceResources.class.getMethods();
        int i = 0;
        while (i < methods.length) {
            String name;
            Method method = methods[i];
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && (name = method.getName()).startsWith("get") && name.endsWith("Font") && method.getParameterTypes().length == 0 && method.getReturnType().getName().equals("org.eclipse.swt.graphics.Font")) {
                Font font = (Font)method.invoke(null, new Object[0]);
                jfaceFonts.add(new FontInfo(name + "()", font, "org.eclipse.jface.resource.JFaceResources." + name + "()", false));
            }
            ++i;
        }
        return jfaceFonts;
    }
}

