/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStorePreferenceListener;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.dstore.internal.core.util.XMLparser;

public abstract class Receiver
extends SecuredThread
implements IDataStorePreferenceListener {
    private Socket _socket;
    private XMLparser _xmlParser;
    private BufferedInputStream _in;
    protected boolean _canExit;

    public Receiver(Socket socket, DataStore dataStore) {
        super(dataStore);
        String enableKeepAlive;
        String iosocketReadTimeout;
        this.setName("DStore Receiver" + this.getName());
        this._socket = socket;
        this._canExit = false;
        this._xmlParser = new XMLparser(dataStore);
        try {
            this._in = new BufferedInputStream(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String keepAliveResponseTimeout = System.getProperty("DSTORE_KEEPALIVE_RESPONSE_TIMEOUT");
        if (keepAliveResponseTimeout != null) {
            this.preferenceChanged("DSTORE_KEEPALIVE_RESPONSE_TIMEOUT", keepAliveResponseTimeout);
        }
        if ((iosocketReadTimeout = System.getProperty("DSTORE_IO_SOCKET_READ_TIMEOUT")) != null) {
            this.preferenceChanged("DSTORE_IO_SOCKET_READ_TIMEOUT", iosocketReadTimeout);
        }
        if ((enableKeepAlive = System.getProperty("DSTORE_KEEPALIVE_ENABLED")) != null) {
            this.preferenceChanged("DSTORE_KEEPALIVE_ENABLED", enableKeepAlive);
        }
    }

    public void finish() {
        this._canExit = true;
        this.handleInput();
    }

    public boolean canExit() {
        return this._canExit;
    }

    public void run() {
        super.run();
        try {
            while (!this._canExit) {
                this.handleInput();
            }
            if (this._canExit && this._dataStore.isConnected()) {
                Exception e = new Exception("Server terminated unexpectedly");
                this.handleError(e);
            }
        }
        catch (Exception e) {
            this._canExit = true;
            e.printStackTrace();
            this.handleError(e);
        }
    }

    public void handleInput() {
        try {
            DataElement rootObject = this._xmlParser.parseDocument(this._in, this._socket);
            if (rootObject != null) {
                String type = rootObject.getType();
                if (!type.equals("FILE")) {
                    this.handleDocument(rootObject);
                }
            } else {
                this._canExit = true;
                if (this._xmlParser.getPanicException() != null && this._dataStore != null && this._dataStore.isConnected()) {
                    this.handleError(this._xmlParser.getPanicException());
                }
            }
        }
        catch (IOException ioe) {
            this._canExit = true;
            this.handleError(ioe);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public Socket socket() {
        return this._socket;
    }

    public abstract void handleDocument(DataElement var1);

    public abstract void handleError(Throwable var1);

    public void preferenceChanged(String property, String value) {
        if (property.equals("DSTORE_IO_SOCKET_READ_TIMEOUT")) {
            int timeout = Integer.parseInt(value);
            this._xmlParser.setIOSocketReadTimeout(timeout);
        } else if (property.equals("DSTORE_KEEPALIVE_RESPONSE_TIMEOUT")) {
            int timeout = Integer.parseInt(value);
            this._xmlParser.setKeepaliveResponseTimeout(timeout);
        } else if (property.equals("DSTORE_KEEPALIVE_ENABLED")) {
            boolean enable = true;
            if (value.equals("false")) {
                enable = false;
            }
            this._xmlParser.setEnableKeepalive(enable);
        }
    }

    public void resetKeepAliveRequest(long timeout) {
        this._xmlParser.resetKeepAliveRequest(timeout, this.socket());
    }
}

