/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.MenuItemIconDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.MUiFactory;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class MenuItemEditor<M extends MMenuItem>
extends AbstractComponentEditor<M> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    @Inject
    @Optional
    protected IProject project;
    @Inject
    IEclipseContext eclipseContext;
    private Action addExpression;

    @PostConstruct
    void init() {
        this.addExpression = new Action(this.Messages.MenuItemEditor_AddCoreExpression, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.CoreExpression")){

            public void run() {
                MUIElement e = (MUIElement)MenuItemEditor.this.getMaster().getValue();
                Command cmd = SetCommand.create((EditingDomain)MenuItemEditor.this.getEditingDomain(), (Object)e, (Object)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE_WHEN, (Object)MUiFactory.INSTANCE.createCoreExpression());
                if (cmd.canExecute()) {
                    MenuItemEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        };
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.MenuItem");
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MMenuItem)object));
        this.enableIdGenerator(UiPackageImpl.Literals.UI_LABEL__LABEL, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, null);
        return this.composite;
    }

    protected CTabFolder createForm(Composite parent, EMFDataBindingContext context, WritableValue<M> master, boolean isImport) {
        Label l;
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        IWidgetValueProperty checkProp = WidgetProperties.buttonSelection();
        IWidgetValueProperty enabled = WidgetProperties.enabled();
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        if (this.getClass() != MenuItemEditor.class) {
            l = new Label(parent, 0);
            l.setText(this.Messages.MenuItemEditor_Type);
            l.setLayoutData((Object)new GridData());
            ComboViewer viewer = new ComboViewer(parent);
            viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if ((ItemType)element == ItemType.CHECK) {
                        return ((MenuItemEditor)MenuItemEditor.this).Messages.ItemType_Check;
                    }
                    if ((ItemType)element == ItemType.PUSH) {
                        return ((MenuItemEditor)MenuItemEditor.this).Messages.ItemType_Push;
                    }
                    return ((MenuItemEditor)MenuItemEditor.this).Messages.ItemType_Radio;
                }
            });
            viewer.setInput((Object)new ItemType[]{ItemType.CHECK, ItemType.PUSH, ItemType.RADIO});
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            viewer.getControl().setLayoutData((Object)gd);
            context.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)viewer), E4Properties.type(this.getEditingDomain()).observeDetail(master));
        }
        ControlFactory.createTranslatedTextField(parent, this.Messages.MenuItemEditor_Label, master, context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.label(this.getEditingDomain()), this.resourcePool, this.project);
        ControlFactory.createTextField(parent, this.Messages.MenuItemEditor_Mnemonics, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.mnemonics(this.getEditingDomain()));
        ControlFactory.createTranslatedTextField(parent, this.Messages.MenuItemEditor_Tooltip, master, context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.tooltip(this.getEditingDomain()), this.resourcePool, this.project);
        l = new Label(parent, 0);
        l.setText(this.Messages.MenuItemEditor_IconURI);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.iconUri(this.getEditingDomain()).observeDetail(master));
        new ImageTooltip((Control)t, this.Messages, this);
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItemIconDialogEditor dialog = new MenuItemIconDialogEditor(b.getShell(), MenuItemEditor.this.eclipseContext, MenuItemEditor.this.project, MenuItemEditor.this.getEditingDomain(), (MMenuItem)MenuItemEditor.this.getMaster().getValue(), MenuItemEditor.this.Messages);
                dialog.open();
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.MenuItemEditor_Enabled);
        l.setLayoutData((Object)new GridData());
        Button b2 = new Button(parent, 32);
        b2.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        context.bindValue((IObservableValue)checkProp.observe((Widget)b2), E4Properties.enabled(this.getEditingDomain()).observeDetail(this.getMaster()));
        l = new Label(parent, 0);
        l.setText(this.Messages.MenuItemEditor_Selected);
        l.setLayoutData((Object)new GridData());
        b2 = new Button(parent, 32);
        b2.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        context.bindValue((IObservableValue)checkProp.observe((Widget)b2), E4Properties.selected(this.getEditingDomain()).observeDetail(this.getMaster()));
        UpdateValueStrategy t2m = new UpdateValueStrategy();
        t2m.setConverter((IConverter)new Converter<Boolean, ItemType>(Boolean.TYPE, ItemType.class){

            public ItemType convert(Boolean fromObject) {
                return null;
            }
        });
        UpdateValueStrategy m2t = new UpdateValueStrategy();
        m2t.setConverter((IConverter)new Converter<ItemType, Boolean>(ItemType.class, Boolean.TYPE){

            public Boolean convert(ItemType fromObject) {
                if (fromObject != ItemType.CHECK && fromObject != ItemType.RADIO) {
                    return false;
                }
                return true;
            }
        });
        context.bindValue((IObservableValue)enabled.observe((Widget)b2), E4Properties.type(this.getEditingDomain()).observeDetail(this.getMaster()), t2m, m2t);
        l = new Label(parent, 0);
        l.setText(this.Messages.ModelTooling_UIElement_VisibleWhen);
        l.setLayoutData((Object)new GridData());
        ComboViewer combo = new ComboViewer(parent);
        combo.getControl().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EClass) {
                    EClass eClass = (EClass)element;
                    return eClass.getName();
                }
                return super.getText(element);
            }
        });
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.Messages.MenuItemEditor_NoExpression);
        list.add(UiPackageImpl.Literals.CORE_EXPRESSION);
        list.add(UiPackageImpl.Literals.IMPERATIVE_EXPRESSION);
        list.addAll(this.getEditor().getFeatureClasses(UiPackageImpl.Literals.EXPRESSION, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE_WHEN));
        combo.setInput(list);
        context.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)combo), E4Properties.visibleWhen(this.getEditingDomain()).observeDetail(this.getMaster()), UpdateValueStrategy.create(new EClass2EObject(this.Messages)), UpdateValueStrategy.create(new EObject2EClass(this.Messages)));
        this.createFormSubTypeForm(parent, context, master);
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MMenuItem.class);
        folder.setSelection(0);
        return folder;
    }

    protected abstract void createFormSubTypeForm(Composite var1, EMFDataBindingContext var2, WritableValue<M> var3);

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return null;
    }

    @Override
    public String getDetailLabel(Object element) {
        return this.getLocalizedLabel((MUILabel)element);
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__LABEL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__ICON_URI}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        if (((MMenuItem)this.getMaster().getValue()).getVisibleWhen() == null) {
            l.add(this.addExpression);
        }
        return l;
    }

    static class EClass2EObject<T>
    extends Converter<Object, T> {
        Messages Messages;

        public EClass2EObject(Messages Messages2) {
            super(EClass.class, EObject.class);
            this.Messages = Messages2;
        }

        public T convert(Object fromObject) {
            if (fromObject == null || fromObject.toString().equals(this.Messages.MenuItemEditor_NoExpression)) {
                return null;
            }
            return (T)EcoreUtil.create((EClass)((EClass)fromObject));
        }
    }

    static class EObject2EClass<T>
    extends Converter<T, Object> {
        Messages Messages;

        public EObject2EClass(Messages Messages2) {
            super(EObject.class, EClass.class);
            this.Messages = Messages2;
        }

        public Object convert(T fromObject) {
            if (fromObject == null) {
                return this.Messages.MenuItemEditor_NoExpression;
            }
            return ((EObject)fromObject).eClass();
        }
    }
}

