/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOUnsetFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOUnsetFeatureDelta {
    public CDOUnsetFeatureDeltaImpl(EStructuralFeature feature) {
        super(feature);
    }

    public CDOUnsetFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.UNSET;
    }

    @Override
    public CDOFeatureDelta copy() {
        return new CDOUnsetFeatureDeltaImpl(this.getFeature());
    }

    @Override
    public Object applyTo(CDORevision revision) {
        EStructuralFeature feature = this.getFeature();
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        if (feature.isUnsettable()) {
            internalRevision.unset(feature);
        } else if (feature.isMany()) {
            Object value = internalRevision.getValue(feature);
            if (value != null) {
                List list = (List)value;
                list.clear();
            }
        } else {
            Object defaultValue = feature.getDefaultValue();
            CDOType type = CDOModelUtil.getType(feature.getEType());
            if (type != null) {
                defaultValue = type.convertToCDO(feature.getEType(), defaultValue);
            }
            internalRevision.set(feature, -1, defaultValue);
        }
        return null;
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster adjuster) {
        return false;
    }

    @Override
    protected String toStringAdditional() {
        return null;
    }
}

