/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.internal.ui.CDOAuthorCache;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.FillLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.chat.ChatComposite;
import org.eclipse.net4j.util.ui.chat.ChatMessage;
import org.eclipse.net4j.util.ui.chat.ChatRenderer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.widgets.EntryControlAdvisor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class CDORemoteSessionsView
extends ContainerView.Default<CDORemoteSessionManager> {
    public static final String ID = "org.eclipse.emf.cdo.ui.CDORemoteSessionsView";
    private static final String TYPE_CHAT_MESSAGE = "org.eclipse.emf.cdo.ui.ChatMessage";
    private static final String CHAT_RENDERER_TYPE = OMPlatform.INSTANCE.getProperty("CHAT_RENDERER_TYPE", "mylyn");
    private static final String CHAT_RENDERER_DESCRIPTION = OMPlatform.INSTANCE.getProperty("CHAT_RENDERER_DESCRIPTION", "Markdown");
    private static final String ENTRY_CONTROL_ADVISOR_TYPE = OMPlatform.INSTANCE.getProperty("ENTRY_CONTROL_ADVISOR_TYPE", "mylyn");
    private static final String ENTRY_CONTROL_ADVISOR_DESCRIPTION = OMPlatform.INSTANCE.getProperty("ENTRY_CONTROL_ADVISOR_DESCRIPTION", "Markdown");
    private static final AtomicInteger CHAT_MESSAGE_IDS = new AtomicInteger();
    private static final ChatMessage[] NO_MESSAGES = new ChatMessage[0];
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part != CDORemoteSessionsView.this) {
                CDORemoteSessionsView.this.handleWindowSelection(selection);
            }
        }
    };
    private final IListener containerListener = new CDORemoteSessionManager.EventAdapter(){

        protected void onLocalSubscriptionChanged(boolean subscribed) {
            CDORemoteSessionsView.this.getViewer().getControl().setEnabled(subscribed);
        }

        protected void onSubscribed(CDORemoteSession remoteSession) {
            this.subscriptionChanged(remoteSession);
        }

        protected void onUnsubscribed(CDORemoteSession remoteSession) {
            this.subscriptionChanged(remoteSession);
        }

        protected void onMessageReceived(CDORemoteSession remoteSession, CDORemoteSessionMessage message) {
            if (CDORemoteSessionsView.TYPE_CHAT_MESSAGE.equals(message.getType())) {
                String content = new String(message.getData(), StandardCharsets.UTF_8);
                CDORemoteSessionsView.this.addMessage(remoteSession, remoteSession.getUserID(), content);
            }
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            CDORemoteSessionsView.this.setContainer(null);
        }

        private void subscriptionChanged(CDORemoteSession remoteSession) {
            if (CDORemoteSessionsView.this.showUnsubscribed) {
                CDORemoteSessionsView.this.refreshElement(remoteSession, true);
            } else {
                CDORemoteSessionsView.this.refreshUserViewer();
            }
        }
    };
    private final Map<CDORemoteSession, List<ChatMessage>> chatMessages = new HashMap<CDORemoteSession, List<ChatMessage>>();
    private final Set<CDORemoteSession> unreadChats = Collections.synchronizedSet(new HashSet());
    private CDOAuthorCache authorCache;
    private ChatComposite chatComposite;
    private CDORemoteSession selectedRemoteSession;
    private boolean showUnsubscribed = (Boolean)OM.PREF_COLLABORATION_SHOW_UNSUBSCRIBED.getValue();

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new ContainerView.ContainerViewItemProvider((ContainerView)this, null){

            protected ContainerItemProvider.Node createNode(ContainerItemProvider.Node parent, Object element) {
                CDORemoteSession remoteSession;
                if (!CDORemoteSessionsView.this.showUnsubscribed && element instanceof CDORemoteSession && !(remoteSession = (CDORemoteSession)element).isSubscribed()) {
                    return null;
                }
                return super.createNode(parent, element);
            }
        };
    }

    protected Control createUI(Composite parent) {
        SashForm ui = new SashForm(parent, 65792);
        super.createUI((Composite)ui);
        Composite composite = new Composite((Composite)ui, 0);
        composite.setLayout((Layout)FillLayoutFactory.fillDefaults().margins(5, 5).create());
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        this.chatComposite = this.createChatComposite(composite);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.handleWindowSelection(selectionService.getSelection());
        selectionService.addPostSelectionListener(this.selectionListener);
        this.updateChat();
        ui.setWeights(new int[]{25, 75});
        return ui;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)new ShowUnsubscribedAction());
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    protected IListener getContainerListener() {
        return this.containerListener;
    }

    protected Image getElementImage(Object element) {
        if (element instanceof CDORemoteSession) {
            Image image = SharedIcons.getImage((String)"obj16/person.gif");
            if (this.unreadChats.contains(element)) {
                image = OM.getOverlayImage(image, URI.createPlatformPluginURI((String)"/org.eclipse.emf.cdo.ui.shared/icons/full/ovr16/unread.gif", (boolean)false), 8, 8);
            }
            return image;
        }
        return super.getElementImage(element);
    }

    protected String getElementText(Object element) {
        if (element instanceof CDORemoteSession) {
            ChatMessage.Author author;
            CDORemoteSession remoteSession = (CDORemoteSession)element;
            String userID = remoteSession.getUserID();
            if (this.authorCache != null && (author = this.authorCache.getAuthor(userID)) != null) {
                return author.getFullName();
            }
            return userID;
        }
        return super.getElementText(element);
    }

    protected Color getElementForeground(Object element) {
        CDORemoteSession remoteSession;
        if (element instanceof CDORemoteSession && !(remoteSession = (CDORemoteSession)element).isSubscribed()) {
            return this.getDisplay().getSystemColor(15);
        }
        return super.getElementForeground(element);
    }

    protected void selectionChanged(IActionBars bars, ITreeSelection selection) {
        CDORemoteSession newRemoteSession = this.getSubscribedRemoteSession((IStructuredSelection)selection);
        if (!Objects.equals(newRemoteSession, this.selectedRemoteSession)) {
            this.selectedRemoteSession = newRemoteSession;
            this.updateChat();
        }
    }

    private ChatComposite createChatComposite(Composite parent) {
        Display display = parent.getDisplay();
        Color entryBackgroundColor = new Color((Device)display, 241, 241, 241);
        parent.addDisposeListener(e -> entryBackgroundColor.dispose());
        ChatRenderer renderer = (ChatRenderer)IPluginContainer.INSTANCE.getElementOrNull("org.eclipse.net4j.util.ui.chatRenderers", CHAT_RENDERER_TYPE, CHAT_RENDERER_DESCRIPTION);
        EntryControlAdvisor entryControlAdvisor = (EntryControlAdvisor)IPluginContainer.INSTANCE.getElementOrNull("org.eclipse.net4j.util.ui.entryControlAdvisors", ENTRY_CONTROL_ADVISOR_TYPE, ENTRY_CONTROL_ADVISOR_DESCRIPTION);
        ChatComposite.Config config = new ChatComposite.Config();
        config.setMessageProvider(this::computeMessages);
        config.setChatRenderer(renderer);
        config.setEntryBackgroundColor(entryBackgroundColor);
        config.setEntryControlAdvisor(entryControlAdvisor);
        config.setSendHandler(this::sendMessage);
        return new ChatComposite(parent, 0, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatMessage[] computeMessages() {
        Map<CDORemoteSession, List<ChatMessage>> map = this.chatMessages;
        synchronized (map) {
            List<ChatMessage> messages = this.chatMessages.get(this.selectedRemoteSession);
            if (ObjectUtil.isEmpty(messages)) {
                return NO_MESSAGES;
            }
            return messages.toArray(new ChatMessage[messages.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(CDORemoteSession remoteSession, final String userID, final String content) {
        List list;
        ChatMessage chatMessage = new ChatMessage(){

            public int getID() {
                return CHAT_MESSAGE_IDS.incrementAndGet();
            }

            public ChatMessage.Author getAuthor() {
                return CDORemoteSessionsView.this.authorCache.getAuthor(userID);
            }

            public long getCreationTime() {
                return System.currentTimeMillis();
            }

            public long getEditTime() {
                return this.getCreationTime();
            }

            public String getContent() {
                return content;
            }

            public ChatMessage getReplyTo() {
                return null;
            }
        };
        Map<CDORemoteSession, List<ChatMessage>> map = this.chatMessages;
        synchronized (map) {
            list = this.chatMessages.computeIfAbsent(remoteSession, k -> new ArrayList());
        }
        list.add(chatMessage);
        if (remoteSession == this.selectedRemoteSession) {
            UIUtil.asyncExec(() -> this.chatComposite.refreshMessageBrowser());
        } else {
            this.unreadChats.add(remoteSession);
            UIUtil.asyncExec(() -> this.refreshElement(remoteSession, true));
        }
    }

    private void sendMessage(String message) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        CDORemoteSession remoteSession = (CDORemoteSession)selection.getFirstElement();
        remoteSession.sendMessage(new CDORemoteSessionMessage(TYPE_CHAT_MESSAGE, message.getBytes(StandardCharsets.UTF_8)));
        this.addMessage(remoteSession, this.getLocalUserID(), message);
    }

    private void updateChat() {
        if (this.selectedRemoteSession != null && this.unreadChats.remove(this.selectedRemoteSession)) {
            this.refreshElement(this.selectedRemoteSession, true);
        }
        this.chatComposite.refreshMessageBrowser();
        this.chatComposite.setVisible(this.selectedRemoteSession != null);
        this.chatComposite.setOwnUserID(this.getLocalUserID());
    }

    private String getLocalUserID() {
        CDORemoteSessionManager container = (CDORemoteSessionManager)this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getLocalSession().getUserID();
    }

    private void refreshUserViewer() {
        this.getItemProvider().clearNodesCache();
        this.refreshViewer(true);
    }

    private void handleWindowSelection(ISelection selection) {
        Object object = UIUtil.getElementIfOne((ISelection)selection);
        CDOSession session = CDOUtil.getSession((Object)object);
        if (session != null) {
            CDORemoteSessionManager oldContainer = (CDORemoteSessionManager)this.getContainer();
            CDORemoteSessionManager newContainer = session.getRemoteSessionManager();
            if (newContainer != oldContainer) {
                this.authorCache = CDOAuthorCache.of(newContainer.getLocalSession());
                this.setContainer((IContainer)newContainer);
            }
        }
    }

    private CDORemoteSession getSubscribedRemoteSession(IStructuredSelection selection) {
        CDORemoteSession remoteSession;
        Object element = selection.getFirstElement();
        if (element instanceof CDORemoteSession && (remoteSession = (CDORemoteSession)element).isSubscribed()) {
            return remoteSession;
        }
        return null;
    }

    private final class ShowUnsubscribedAction
    extends Action {
        public ShowUnsubscribedAction() {
            super("Show Unsubscribed Users", 2);
            this.setChecked(CDORemoteSessionsView.this.showUnsubscribed);
        }

        public void run() {
            CDORemoteSessionsView.this.showUnsubscribed = !CDORemoteSessionsView.this.showUnsubscribed;
            OM.PREF_COLLABORATION_SHOW_UNSUBSCRIBED.setValue((Object)CDORemoteSessionsView.this.showUnsubscribed);
            CDORemoteSessionsView.this.refreshUserViewer();
        }
    }
}

