/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement.required_element_missingCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class required_element_missingCodeAction
implements ICodeActionParticipant {
    private final Map<String, ICodeActionResolvesParticipant> resolveCodeActionParticipants = new HashMap<String, ICodeActionResolvesParticipant>();

    public required_element_missingCodeAction() {
        this.resolveCodeActionParticipants.put(required_element_missingCodeActionResolver.PARTICIPANT_ID, new required_element_missingCodeActionResolver());
    }

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Diagnostic diagnostic = request.getDiagnostic();
        try {
            Range diagnosticRange = diagnostic.getRange();
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            if (node == null || !node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            XMLGenerator generator = request.getXMLGenerator();
            String insertStrRequired = null;
            String insertStrAll = null;
            if (!request.canSupportResolve()) {
                insertStrRequired = generator.generateMissingElements((ContentModelManager)request.getComponent(ContentModelManager.class), element, true);
                insertStrAll = generator.generateMissingElements((ContentModelManager)request.getComponent(ContentModelManager.class), element, false);
            }
            CodeAction insertRequriedExpectedElementCodeAction = required_element_missingCodeAction.createInsertExpectedElementsCodeAction(true, element, insertStrRequired, request, cancelChecker);
            CodeAction insertAllExpectedElementCodeAction = required_element_missingCodeAction.createInsertExpectedElementsCodeAction(false, element, insertStrAll, request, cancelChecker);
            codeActions.add(insertRequriedExpectedElementCodeAction);
            codeActions.add(insertAllExpectedElementCodeAction);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static CodeAction createInsertExpectedElementsCodeAction(boolean isGenerateRequired, DOMElement domElement, String insertStr, ICodeActionRequest request, CancelChecker cancelChecker) throws BadLocationException {
        String title;
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        String string = title = isGenerateRequired ? "Insert only required elements" : "Insert all expected elements";
        if (request.canSupportResolve()) {
            JsonObject data = DataEntryField.createData(document.getDocumentURI(), required_element_missingCodeActionResolver.PARTICIPANT_ID);
            return required_element_missingCodeAction.insertExpectedElementsUnresolvedCodeAction(title, diagnostic, data, isGenerateRequired);
        }
        return required_element_missingCodeAction.insertExpectedElementCodeAction(document, title, domElement, insertStr, diagnostic);
    }

    private static CodeAction insertExpectedElementsUnresolvedCodeAction(String title, Diagnostic diagnostic, JsonObject data, boolean isGenerateRequired) {
        CodeAction codeAction = new CodeAction(title);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        String required_field = isGenerateRequired ? "true" : "false";
        data.addProperty("onlyGenerateRequired", required_field);
        codeAction.setData(data);
        return codeAction;
    }

    @Override
    public ICodeActionResolvesParticipant getResolveCodeActionParticipant(String participantId) {
        return this.resolveCodeActionParticipants.get(participantId);
    }

    private static CodeAction insertExpectedElementCodeAction(DOMDocument document, String title, DOMElement element, String insertStr, Diagnostic diagnostic) throws BadLocationException {
        Position childElementPositionStartTag = document.positionAt(element.getStartTagCloseOffset() + 1);
        Position childElementPositionEndTag = document.positionAt(element.getEndTagOpenOffset());
        Range targetRange = new Range(childElementPositionStartTag, childElementPositionEndTag);
        return CodeActionFactory.replace(title, targetRange, insertStr, document.getTextDocument(), diagnostic);
    }
}

