/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.launch.debug;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.adwp.BooleanValue;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.NullValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.RealValue;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.launch.debug.NetworkDebugger;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

public class LocalObjectReference
extends ObjectReference {
    private static Map<List<Object>, ObjectReference> values = new HashMap<List<Object>, ObjectReference>();
    private static Map<Integer, ObjectReference> valuesById = new HashMap<Integer, ObjectReference>();
    private static int idGenerator;
    protected Object object;
    protected NetworkDebugger debugger;
    private ExecEnv execEnv;

    protected LocalObjectReference(Object object, int id, NetworkDebugger debugger) {
        super(id);
        this.object = object;
        this.debugger = debugger;
        this.execEnv = debugger.getExecEnv();
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public static ObjectReference valueOf(int objectId) {
        Integer id = objectId;
        ObjectReference ret = valuesById.get(id);
        return ret;
    }

    public static ObjectReference valueOf(Object object, NetworkDebugger debugger) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(object);
        key.add(debugger);
        ObjectReference ret = values.get(key);
        if (ret == null) {
            int id = idGenerator++;
            ret = new LocalObjectReference(object, id, debugger);
            values.put(key, ret);
            valuesById.put(id, ret);
        }
        return ret;
    }

    public Value get(String propName) {
        Value ret = null;
        AbstractStackFrame frame = this.debugger.getLastFrame();
        try {
            Object type = this.getType();
            Operation ai = this.execEnv.getAttributeInitializer(type, propName);
            ret = ai != null ? this.object2value(this.execEnv.getHelperValue(frame, type, this.object, propName)) : (this.object instanceof HasFields ? this.object2value(((HasFields)this.object).get(frame, (Object)propName)) : this.object2value(this.execEnv.getModelAdapter().get(frame, this.object, propName)));
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return ret;
    }

    public void set(String propName, Value value) {
        Object realValue = this.value2object(value);
        AbstractStackFrame frame = this.debugger.getLastFrame();
        if (this.object instanceof HasFields) {
            ((HasFields)this.object).set(frame, (Object)propName, (Object)value);
        } else {
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                boolean temp = true;
                while (temp) {
                    temp = c.remove(OclUndefined.SINGLETON);
                }
            } else if (realValue instanceof OclUndefined) {
                realValue = null;
            }
            this.execEnv.getModelAdapter().set(frame, this.object, propName, realValue);
        }
    }

    private Object value2object(Value value) {
        Object ret = null;
        if (value instanceof LocalObjectReference) {
            ret = ((LocalObjectReference)value).object;
        } else if (value instanceof StringValue) {
            ret = ((StringValue)value).getValue();
        } else if (value instanceof IntegerValue) {
            ret = ((IntegerValue)value).getValue();
        } else if (value instanceof RealValue) {
            ret = ((RealValue)value).getValue();
        } else if (value instanceof BooleanValue) {
            ret = ((BooleanValue)value).getValue();
        }
        return ret;
    }

    private Object getType() {
        return this.execEnv.getModelAdapter().getType(this.object);
    }

    private Method getClassMethod(String name) {
        Method[] methods = this.object.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(name)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public Value call(String opName, List<Value> args) {
        boolean debug = false;
        Value ret = null;
        Object type = this.getType();
        Operation op = this.execEnv.getOperation(type, (Object)opName);
        if (op == null) {
            Method method = this.getClassMethod(opName);
            if (method != null) {
                try {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    int i = 0;
                    while (i < method.getParameterTypes().length) {
                        realArgs[i] = this.value2object(args.get(i));
                        ++i;
                    }
                    ret = this.object2value(method.invoke(this.object, realArgs));
                }
                catch (IllegalArgumentException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                ATLLogger.severe((String)("Operation not found: " + opName + " on " + this.object + " : " + type));
            }
        } else {
            ArrayList<Object> realArgs = new ArrayList<Object>();
            realArgs.add(this.value2object((Value)this));
            for (Value v : args) {
                realArgs.add(this.value2object(v));
            }
            StackFrame frame = new StackFrame(this.execEnv, new ASMModule(), op);
            frame.setLocalVars(realArgs.toArray());
            Object o = op.exec(frame.enter());
            ret = this.object2value(o);
        }
        return ret;
    }

    private Value object2value(Object o) {
        return LocalObjectReference.object2value(o, this.debugger);
    }

    public static Value object2value(Object o, NetworkDebugger debugger) {
        Object ret = null;
        ret = o instanceof String ? StringValue.valueOf((String)((String)o)) : (o instanceof Integer ? IntegerValue.valueOf((int)((Integer)o)) : (o instanceof Double ? RealValue.valueOf((double)((Double)o)) : (o instanceof Boolean ? BooleanValue.valueOf((boolean)((Boolean)o)) : (o == null ? new NullValue() : LocalObjectReference.valueOf(o, debugger)))));
        return ret;
    }
}

