/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import java.util.Vector;

public class StringMatcher {
    protected static final char SINGLE_WILDCARD = '\u0000';
    protected String myPattern;
    protected int myLength;
    protected boolean isIgnoreWildCards;
    protected boolean isIgnoreCase;
    protected boolean hasLeadingStar;
    protected boolean hasTrailingStar;
    protected String[] mySegments;
    protected int myBound = 0;

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.isIgnoreCase = ignoreCase;
        this.isIgnoreWildCards = ignoreWildCards;
        this.myPattern = pattern;
        this.myLength = pattern.length();
        if (this.isIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        if (end < 0 || start >= end) {
            return null;
        }
        if (this.myLength == 0) {
            return new Position(start, start);
        }
        if (this.isIgnoreWildCards) {
            int x = this.posIn(text, start, end);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.myLength);
        }
        int segCount = this.mySegments.length;
        if (segCount == 0) {
            return new Position(start, end);
        }
        int curPos = start;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < end) {
            String current = this.mySegments[i];
            int nextMatch = this.regExpPosIn(text, curPos, end, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        if (this.isIgnoreWildCards) {
            return end - start == this.myLength && this.myPattern.regionMatches(this.isIgnoreCase, 0, text, start, this.myLength) != false;
        }
        segCount = this.mySegments.length;
        if (segCount == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
            return true;
        }
        if (start == end) {
            return this.myLength == 0;
        }
        if (this.myLength == 0) {
            return start == end;
        }
        tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        tCurPos = start;
        bound = end - this.myBound;
        if (bound < 0) {
            return false;
        }
        i = 0;
        current = this.mySegments[i];
        segLength = current.length();
        if (!this.hasLeadingStar) {
            if (!this.regExpRegionMatches(text, start, current, 0, segLength)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        if (this.mySegments.length != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl39
        return tCurPos == end;
lbl-1000:
        // 1 sources

        {
            current = this.mySegments[i];
            k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, end, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, end, current)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
lbl39:
            // 2 sources

            ** while (i < segCount)
        }
lbl40:
        // 1 sources

        if (!this.hasTrailingStar && tCurPos != end) {
            clen = current.length();
            return this.regExpRegionMatches(text, end - clen, current, 0, clen);
        }
        return i == segCount;
    }

    private void parseNoWildCards() {
        this.mySegments = new String[1];
        this.mySegments[0] = this.myPattern;
        this.myBound = this.myLength;
    }

    private void parseWildCards() {
        if (this.myPattern.startsWith("*")) {
            this.hasLeadingStar = true;
        }
        if (this.myPattern.endsWith("*") && this.myLength > 1 && this.myPattern.charAt(this.myLength - 2) != '\\') {
            this.hasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        block5: while (pos < this.myLength) {
            char c = this.myPattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.myLength) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.myPattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.myBound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.myBound += buf.length();
        }
        this.mySegments = new String[temp.size()];
        temp.copyInto(this.mySegments);
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.myLength;
        if (!this.isIgnoreCase) {
            int i = text.indexOf(this.myPattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.myPattern, 0, this.myLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        while (plen-- > 0) {
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.isIgnoreWildCards && pchar == '\u0000' || pchar == tchar || this.isIgnoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.isIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class Position {
        int start;
        int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

