/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.CstTransformation;
import org.eclipse.m2m.internal.qvt.oml.ExecutionDiagnosticImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.Transformation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackOverFlowError;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

public class InternalTransformationExecutor {
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fOperationalTransformation;
    private QvtOperationalEnvFactory fEnvFactory;
    private Transformation fTransformation;

    public InternalTransformationExecutor(URI uri) {
        this(new CstTransformation(uri));
    }

    public InternalTransformationExecutor(URI uri, EPackage.Registry registry) {
        this(new CstTransformation(uri, registry));
    }

    public InternalTransformationExecutor(Transformation transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("null transformation");
        }
        this.fTransformation = transformation;
    }

    public URI getURI() {
        return this.fTransformation.getURI();
    }

    public ResourceSet getResourceSet() {
        return this.fTransformation.getResourceSet();
    }

    public Diagnostic loadTransformation(IProgressMonitor monitor) {
        try {
            if (this.fLoadDiagnostic == null) {
                this.doLoad(monitor);
            }
            ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
            return executionDiagnostic;
        }
        finally {
            monitor.done();
        }
    }

    public CompiledUnit getUnit() {
        return this.fTransformation.getUnit();
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        if (executionContext == null) {
            throw new IllegalArgumentException();
        }
        IProgressMonitor monitor = executionContext.getProgressMonitor();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind(Messages.Executor_Executing, this.getURI().toString()), (int)2);
            this.checkLegalModelParams(modelParameters);
            this.loadTransformation((IProgressMonitor)progress.split(1));
            if (!EmfUtilPlugin.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
                ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
                return executionDiagnostic;
            }
            Context context = new Context(executionContext, (IProgressMonitor)progress.split(1));
            try {
                ExecutionDiagnostic executionDiagnostic = this.doExecute(modelParameters, context);
                return executionDiagnostic;
            }
            catch (QvtRuntimeException e) {
                ExecutionDiagnostic executionDiagnostic;
                block10: {
                    executionDiagnostic = InternalTransformationExecutor.createExecutionFailure(e, context);
                    if (monitor == null) break block10;
                    monitor.done();
                }
                return executionDiagnostic;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private ExecutionDiagnostic doExecute(ModelExtent[] args, IContext context) {
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        ExecutionDiagnostic modelParamsDiagnostic = this.initArguments(evaluationEnv, this.fOperationalTransformation, args);
        if (!EmfUtilPlugin.isSuccess((Diagnostic)modelParamsDiagnostic)) {
            return modelParamsDiagnostic;
        }
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(this.getURI());
        EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> evaluator = factory.createEvaluationVisitor(rootEnv, (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evaluationEnv, null);
        assert (evaluator instanceof InternalEvaluator) : "expecting InternalEvaluator implementation";
        InternalEvaluator rawEvaluator = (InternalEvaluator)evaluator;
        Object evalResult = rawEvaluator.execute(this.fOperationalTransformation);
        if (evalResult instanceof QvtEvaluationResult) {
            int extentIndex = 0;
            int i = 0;
            while (i < this.fOperationalTransformation.getModelParameter().size()) {
                ModelParameter p = (ModelParameter)this.fOperationalTransformation.getModelParameter().get(i);
                if (p.getKind() != DirectionKind.IN) {
                    ModelExtentContents extent = ((QvtEvaluationResult)evalResult).getModelExtents().get(extentIndex++);
                    args[i].setContents(extent.getAllRootElements());
                }
                ++i;
            }
        } else {
            List<Object> resultArgs = evaluationEnv.getOperationArgs();
            int i = 0;
            for (Object nextResultArg : resultArgs) {
                ModelInstance modelInstance = (ModelInstance)nextResultArg;
                ModelParameterExtent extent = modelInstance.getExtent();
                List<EObject> allRootElements = extent.getContents().getAllRootElements();
                try {
                    args[i++].setContents(allRootElements);
                }
                catch (UnsupportedOperationException e) {
                    return new ExecutionDiagnosticImpl(4, 140, NLS.bind(Messages.ReadOnlyExtentModificationError, i - 1));
                }
            }
        }
        Trace traces = evaluationEnv.getAdapter(InternalEvaluationEnv.class).getTraces();
        this.handleExecutionTraces(traces);
        return evalResult instanceof QvtEvaluationResult ? ((QvtEvaluationResult)evalResult).getExecutionDiagnostic() : ExecutionDiagnosticImpl.createOkInstance();
    }

    protected void handleExecutionTraces(Trace traces) {
    }

    private void doLoad(IProgressMonitor monitor) {
        this.fOperationalTransformation = this.fTransformation.getTransformation(monitor);
        this.fLoadDiagnostic = this.fTransformation.getDiagnostic();
    }

    private ExecutionDiagnostic initArguments(QvtOperationalEvaluationEnv evalEnv, OperationalTransformation transformationModel, ModelExtent[] args) {
        EList<ModelParameter> modelParameters = transformationModel.getModelParameter();
        if (modelParameters.size() > args.length) {
            return new ExecutionDiagnosticImpl(4, 140, NLS.bind(Messages.InvalidModelParameterCountError, args.length, modelParameters.size()));
        }
        ExecutionDiagnosticImpl result = ExecutionDiagnosticImpl.createOkInstance();
        ArrayList<ModelParameterExtent> extents = new ArrayList<ModelParameterExtent>(modelParameters.size());
        int argCount = 0;
        for (ModelParameter modelParam : modelParameters) {
            ModelExtent nextArg = args[argCount++];
            ModelParameterExtent nextExtent = modelParam.getKind() != DirectionKind.OUT ? new ModelParameterExtent(nextArg.getContents(), this.getResourceSet(), modelParam) : new ModelParameterExtent(this.getResourceSet());
            evalEnv.addModelExtent(nextExtent);
            extents.add(nextExtent);
        }
        List<ModelInstance> modelArgs = ModelParameterHelper.createModelArguments(transformationModel, extents);
        evalEnv.getOperationArgs().addAll(modelArgs);
        return result;
    }

    public OperationalTransformation getTransformation() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fOperationalTransformation;
    }

    public void setEnvironmentFactory(QvtOperationalEnvFactory factory) {
        this.fEnvFactory = factory;
    }

    protected QvtOperationalEnvFactory getEnvironmentFactory() {
        return this.fEnvFactory != null ? this.fEnvFactory : new QvtOperationalEnvFactory();
    }

    public void cleanup() {
        this.setEnvironmentFactory(null);
        this.fTransformation.cleanup();
    }

    private static ExecutionDiagnostic createExecutionFailure(QvtRuntimeException qvtRuntimeException, IContext context) {
        int code = 0;
        int severity = 4;
        String message = qvtRuntimeException.getLocalizedMessage();
        Object[] data = new Object[]{qvtRuntimeException};
        if (qvtRuntimeException instanceof QvtException) {
            code = ((QvtException)qvtRuntimeException).getExceptionType() == QvtOperationalStdLibrary.INSTANCE.getAssertionFailedClass() ? 100 : 120;
        } else if (qvtRuntimeException instanceof QvtInterruptedExecutionException) {
            code = 110;
            severity = 8;
        } else {
            code = 120;
            if (!(qvtRuntimeException instanceof QvtStackOverFlowError)) {
                Throwable cause = qvtRuntimeException.getCause();
                data = new Object[]{cause != null ? cause : qvtRuntimeException};
            } else {
                message = Messages.StackTraceOverFlowError;
            }
        }
        if (message == null) {
            message = NLS.bind(Messages.QVTRuntimeExceptionCaught, ((Object)((Object)qvtRuntimeException)).getClass().getName());
        }
        ExecutionDiagnosticImpl diagnostic = new ExecutionDiagnosticImpl(severity, code, message, data);
        diagnostic.setStackTrace(qvtRuntimeException.getQvtStackTrace());
        if (context != null) {
            diagnostic.addAll(context.getExecutionDiagnostic());
        }
        return diagnostic;
    }

    private void checkLegalModelParams(ModelExtent[] extents) throws IllegalArgumentException {
        if (extents == null) {
            throw new IllegalArgumentException("Null model parameters");
        }
        int i = 0;
        while (i < extents.length) {
            if (extents[i] == null) {
                throw new IllegalArgumentException("Null model parameter[" + i + "]");
            }
            ++i;
        }
    }

    public String toString() {
        return "QVTO-Executor: " + this.fTransformation.getURI();
    }

    public static class TracesAwareExecutor
    extends InternalTransformationExecutor {
        private Trace fTraces;

        public TracesAwareExecutor(URI uri, EPackage.Registry registry) {
            super(uri, registry);
        }

        public TracesAwareExecutor(URI uri) {
            super(uri);
        }

        public TracesAwareExecutor(Transformation transformation) {
            super(transformation);
        }

        public Trace getTraces() {
            return this.fTraces;
        }

        @Override
        protected void handleExecutionTraces(Trace traces) {
            super.handleExecutionTraces(traces);
            this.fTraces = traces;
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.fTraces = null;
        }
    }
}

