/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.net4j.util.ObjectUtil;

public final class Holder<T>
implements Consumer<T>,
Supplier<T> {
    private final Supplier<T> creator;
    private final T unset;
    private T element;

    public Holder() {
        this.creator = null;
        this.unset = null;
    }

    public Holder(T element) {
        this();
        this.set(element);
    }

    public Holder(Supplier<T> creator) {
        this(creator, null);
    }

    public Holder(Supplier<T> creator, T unset) {
        this.creator = creator;
        this.unset = unset;
        this.element = unset;
    }

    public boolean isSet() {
        return this.element != this.unset;
    }

    public T handleIfSet(Consumer<T> consumer) {
        T elem = this.getIfSet();
        ObjectUtil.ifNotNull(elem, consumer);
        return elem;
    }

    public T getIfSet() {
        return this.isSet() ? (T)this.element : null;
    }

    @Override
    public T get() {
        if (!this.isSet() && this.creator != null) {
            this.element = this.creator.get();
        }
        return this.element;
    }

    public T set(T element) {
        T oldElement = this.element;
        this.element = element;
        return oldElement;
    }

    @Override
    public void accept(T element) {
        this.set(element);
    }
}

