/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class CompositeApiImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private Image fOriginalImage = null;
    private final int fFlags;
    private Point fSize;

    public CompositeApiImageDescriptor(Image original, int flags) {
        this.fOriginalImage = original;
        this.fFlags = flags;
    }

    protected void drawCompositeImage(int width, int height) {
        CompositeImageDescriptor.CachedImageDataProvider bg = this.createCachedImageDataProvider(this.fOriginalImage);
        this.drawImage((ImageDataProvider)bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        this.drawTopRight();
    }

    private void drawTopRight() {
        Point pos = new Point(this.getSize().x, 0);
        if ((this.fFlags & 1) != 0) {
            this.addTopRightImage(ApiUIPlugin.getImageDescriptor("IMG_OVR_ERROR"), pos);
        } else if ((this.fFlags & 2) != 0) {
            this.addTopRightImage(ApiUIPlugin.getImageDescriptor("IMG_OVR_WARNING"), pos);
        }
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(desc);
        int x = pos.x - data.getWidth();
        if (x >= 0) {
            this.drawImage((ImageDataProvider)data, x, pos.y);
            pos.x = x;
        }
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.fOriginalImage.getImageData();
            this.fSize = new Point(data.width, data.height);
        }
        return this.fSize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeApiImageDescriptor) {
            CompositeApiImageDescriptor other = (CompositeApiImageDescriptor)((Object)obj);
            return this.fOriginalImage.equals((Object)other.fOriginalImage) && this.fFlags == other.fFlags;
        }
        return false;
    }

    public int hashCode() {
        return this.fOriginalImage.hashCode() | this.fFlags;
    }
}

