/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.FormatterUIPlugin;
import org.eclipse.php.formatter.ui.Logger;
import org.eclipse.php.formatter.ui.preferences.AlreadyExistsDialog;
import org.eclipse.php.formatter.ui.preferences.CodeFormatterPreview;
import org.eclipse.php.formatter.ui.preferences.CreateProfileDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.PreferencesAccess;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.eclipse.php.formatter.ui.preferences.ProfileStore;
import org.eclipse.php.formatter.ui.preferences.RenameProfileDialog;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CodeFormatterConfigurationBlock
extends PHPCoreOptionsConfigurationBlock
implements SelectionListener {
    private static final Key PROFILE_KEY = new Key("org.eclipse.php.formatter.core", "formatterProfile");
    private static final String DIALOGSTORE_LASTLOADPATH = "org.eclipse.php.formatter.ui.loadpath";
    private static final String DIALOGSTORE_LASTSAVEPATH = "org.eclipse.php.formatter.ui.savepath";
    private final String PREVIEW = "<?php\n class Example {  var $theInt= 1;  function foo($a, $b) {    switch($a) {    case 0:       $Other->doFoo();      break;    default:      $Other->doBaz();    }  }  function bar($v) {    for ($i= 0; $i < 10; $i++) {      $v->add($i);    }  }} \n?>";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected final ProfileManager fProfileManager;
    protected CodeFormatterPreview fPHPPreview;
    private PixelConverter fPixConv;
    private IScopeContext fCurrContext;
    private IScopeContext fInstanceScope = InstanceScope.INSTANCE;

    public CodeFormatterConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, new Key[]{PROFILE_KEY}, container);
        List<ProfileManager.Profile> profiles = null;
        try {
            profiles = ProfileStore.readProfiles(this.fInstanceScope);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (profiles == null) {
            try {
                profiles = ProfileStore.readProfilesFromPreferences(DefaultScope.INSTANCE);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        if (profiles == null) {
            profiles = new ArrayList<ProfileManager.Profile>();
        }
        PreferencesAccess access = PreferencesAccess.getWorkingCopyPreferences(this.fManager);
        this.fCurrContext = project != null ? access.getProjectScope(project) : access.getInstanceScope();
        this.fProfileManager = new ProfileManager(profiles, this.fCurrContext);
        new StoreUpdater();
    }

    protected Control createContents(Composite parent) {
        int numColumns = 5;
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        this.fProfileCombo = CodeFormatterConfigurationBlock.createProfileCombo(this.fComposite, 2);
        this.fEditButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc, 32);
        this.fRenameButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_rename_button_desc, 32);
        this.fDeleteButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_remove_button_desc, 32);
        Composite group = this.createComposite(this.fComposite, 4);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 5;
        group.setLayoutData((Object)groupData);
        this.fNewButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_new_button_desc, 32);
        ((GridData)this.createLabel((Composite)group, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_load_button_desc, 128);
        this.fSaveButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_save_button_desc, 128);
        this.createLabel(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, 5);
        this.configurePreview(this.fComposite, 5);
        new ButtonController();
        new ProfileComboController();
        new PreviewController();
        return this.fComposite;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    public void performDefaults() {
        String[] items = this.fProfileCombo.getItems();
        ProfileManager.Profile defaultProfile = this.fProfileManager.getDefaultProfile();
        if (defaultProfile != null) {
            int index = 0;
            int i = 0;
            while (i < items.length) {
                if (items[i].equalsIgnoreCase(defaultProfile.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.fProfileCombo.select(index);
            this.fProfileManager.setSelected(defaultProfile);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fComposite.isEnabled()) {
            int index = this.fProfileCombo.getSelectionIndex();
            ProfileManager.Profile selectedProfile = this.fProfileManager.getSortedProfiles().get(index);
            this.fProfileManager.setSelected(selectedProfile);
        }
        return super.performOk();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int span) {
        GridData gd = new GridData(4, 1, false, false);
        gd.horizontalSpan = span;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void configurePreview(Composite composite, int numColumns) {
        this.fPHPPreview = new CodeFormatterPreview(CodeFormatterPreferences.getDefaultPreferences(), composite);
        this.fPHPPreview.setPreviewText("<?php\n class Example {  var $theInt= 1;  function foo($a, $b) {    switch($a) {    case 0:       $Other->doFoo();      break;    default:      $Other->doBaz();    }  }  function bar($v) {    for ($i= 0; $i < 10; $i++) {      $v->add($i);    }  }} \n?>");
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fPHPPreview.getControl().setLayoutData((Object)gd);
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodeFormatterConfigurationBlock.this.fProfileManager, null);
        }

        @Override
        public void update(Observable o, Object arg) {
            ProfileManager.Profile selected = ((ProfileManager)o).getSelected();
            boolean notBuiltIn = selected != null && !selected.isBuiltInProfile();
            CodeFormatterConfigurationBlock.this.fEditButton.setText(notBuiltIn ? FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc : FormatterMessages.CodingStyleConfigurationBlock_show_button_desc);
            CodeFormatterConfigurationBlock.this.fEditButton.setEnabled(selected != null);
            CodeFormatterConfigurationBlock.this.fDeleteButton.setEnabled(notBuiltIn);
            CodeFormatterConfigurationBlock.this.fSaveButton.setEnabled(notBuiltIn);
            CodeFormatterConfigurationBlock.this.fRenameButton.setEnabled(notBuiltIn);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == CodeFormatterConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void renameButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null || CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().isBuiltInProfile()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            RenameProfileDialog renameDialog = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), profile, CodeFormatterConfigurationBlock.this.fProfileManager);
            if (renameDialog.open() == 0) {
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(renameDialog.getRenamedProfile());
            }
        }

        private void modifyButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this, CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager.getSelected(), CodeFormatterConfigurationBlock.this.fProfileManager, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null) {
                return;
            }
            if (MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_title, (String)Messages.format((String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_question, (Object)CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                CodeFormatterConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this, CodeFormatterConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile(), CodeFormatterConfigurationBlock.this.fProfileManager, true);
            modifyDialog.open();
        }

        private void saveButtonPressed() {
            String path;
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null) {
                return;
            }
            ProfileManager.Profile selected = CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            FileDialog dialog = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_save_profile_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            dialog.setFileName(selected.getName() + ".xml");
            String lastPath = FormatterUIPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            FormatterUIPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH, dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_title, (String)Messages.format((String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_message, (Object)path))) {
                return;
            }
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(selected);
            try {
                ProfileStore.writeProfilesToFile(profiles, file);
            }
            catch (CoreException e) {
                String title = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_title;
                String message = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_message;
                ExceptionHandler.handle((CoreException)e, (Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
            }
        }

        private void loadButtonPressed() {
            AlreadyExistsDialog aeDialog;
            String path;
            FileDialog dialog = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_load_profile_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = FormatterUIPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            FormatterUIPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH, dialog.getFilterPath());
            File file = new File(path);
            List<ProfileManager.Profile> profiles = null;
            try {
                profiles = ProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException e) {
                String title = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                String message = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_message;
                ExceptionHandler.handle((CoreException)e, (Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
            if (CodeFormatterConfigurationBlock.this.fProfileManager.containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), profile, CodeFormatterConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            CodeFormatterConfigurationBlock.this.fProfileManager.addProfile(profile);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() != null) {
                CodeFormatterConfigurationBlock.this.fPHPPreview.setPreferences(new CodeFormatterPreferences(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getSettings()));
                CodeFormatterConfigurationBlock.this.fPHPPreview.update();
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null) break;
                    CodeFormatterConfigurationBlock.this.fPHPPreview.setPreferences(new CodeFormatterPreferences(((ProfileManager)o).getSelected().getSettings()));
                    CodeFormatterConfigurationBlock.this.fPHPPreview.update();
                }
            }
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List<ProfileManager.Profile> fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles();
            CodeFormatterConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            ProfileManager.Profile selectedProfile = this.fSortedProfiles.get(index);
            CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(selectedProfile);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                    this.updateSelection();
                    break;
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setItems(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedDisplayNames());
        }

        private void updateSelection() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected() == null) {
                return;
            }
            CodeFormatterConfigurationBlock.this.fProfileCombo.setText(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        ProfileStore.writeProfiles(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles(), CodeFormatterConfigurationBlock.this.fInstanceScope);
                        CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                    }
                    catch (CoreException x) {
                        Logger.logException(x);
                    }
                    break;
                }
                case 1: {
                    CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                }
            }
        }
    }
}

