/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import lpg.lpgjavaruntime.BadParseException;
import lpg.lpgjavaruntime.BadParseSymFileException;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.NotDeterministicParseTableException;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.Stacks;
import lpg.lpgjavaruntime.TokenStream;

public class DeterministicParser
extends Stacks {
    private Monitor monitor = null;
    private int START_STATE;
    private int NUM_RULES;
    private int LA_STATE_OFFSET;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int lastToken;
    private int currentAction;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;

    public final int getCurrentRule() {
        return this.currentAction;
    }

    public final int getFirstToken() {
        return this.getToken(1);
    }

    public final int getFirstToken(int i) {
        return this.getToken(i);
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    public final int getLastToken(int i) {
        return i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(i + 1));
    }

    public DeterministicParser(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.tokStream = tokStream;
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.NUM_RULES = prs.getNumRules();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        if (!prs.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (prs.getBacktrack()) {
            throw new NotDeterministicParseTableException();
        }
    }

    public DeterministicParser(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this(tokStream, prs, ra);
        this.monitor = monitor;
    }

    private final void processReductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    public Object parse() throws BadParseException {
        this.tokStream.reset();
        int curtok = this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(curtok);
        this.lastToken = this.tokStream.getPrevious(curtok);
        this.reallocateStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return null;
            }
            try {
                this.stateStack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = this.currentAction;
            }
            this.locationStack[this.stateStackTop] = curtok;
            this.currentAction = this.tAction(this.currentAction, current_kind);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.processReductions();
                continue;
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.lastToken = curtok;
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.currentAction -= this.ERROR_ACTION;
                this.processReductions();
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.lastToken = curtok;
            curtok = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(curtok);
        }
        if (this.currentAction == this.ERROR_ACTION) {
            throw new BadParseException(curtok);
        }
        return this.parseStack[0];
    }

    private int tAction(int act, int sym) {
        if ((act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET) {
            int next_token = this.tokStream.peek();
            act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            while (act > this.LA_STATE_OFFSET) {
                next_token = this.tokStream.getNext(next_token);
                act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            }
        }
        return act;
    }
}

