/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.nebula.jface.gridviewer.CheckEditingSupport;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridTreeViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public final class GridViewerColumn
extends ViewerColumn {
    private ColumnViewer viewer;
    private GridColumn column;
    private CheckEditingSupport checkEditingSupport;
    protected Listener columnResizeListener = null;
    private EditingSupport currentEditingSupport;

    public GridViewerColumn(GridTableViewer viewer, int style) {
        this(viewer, style, -1);
    }

    public GridViewerColumn(GridTreeViewer viewer, int style) {
        this(viewer, style, -1);
    }

    public GridViewerColumn(GridTableViewer viewer, int style, int index) {
        this(viewer, GridViewerColumn.createColumn((Grid)viewer.getControl(), style, index));
    }

    public GridViewerColumn(GridTreeViewer viewer, int style, int index) {
        this(viewer, GridViewerColumn.createColumn((Grid)viewer.getControl(), style, index));
    }

    public GridViewerColumn(GridTreeViewer viewer, GridColumn column) {
        this((ColumnViewer)viewer, column);
    }

    public GridViewerColumn(GridTableViewer viewer, GridColumn column) {
        this((ColumnViewer)viewer, column);
    }

    GridViewerColumn(ColumnViewer viewer, GridColumn column) {
        super(viewer, (Widget)column);
        this.viewer = viewer;
        this.column = column;
        this.hookColumnResizeListener();
        this.hookVisibilityListener();
    }

    private static GridColumn createColumn(Grid table, int style, int index) {
        if (index >= 0) {
            return new GridColumn(table, style, index);
        }
        return new GridColumn(table, style);
    }

    public GridColumn getColumn() {
        return this.column;
    }

    public void setEditingSupport(EditingSupport editingSupport) {
        this.currentEditingSupport = editingSupport;
        if (!this.getColumn().isVisible()) {
            return;
        }
        if (editingSupport instanceof CheckEditingSupport) {
            if (this.checkEditingSupport == null) {
                final int colIndex = this.getColumn().getParent().indexOf(this.getColumn());
                this.getColumn().getParent().addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.detail == 32 && event.index == colIndex) {
                            GridItem item = (GridItem)event.item;
                            Object element = item.getData();
                            GridViewerColumn.this.checkEditingSupport.setValue(element, new Boolean(item.getChecked(colIndex)));
                        }
                    }
                });
            }
            this.checkEditingSupport = (CheckEditingSupport)editingSupport;
        } else {
            super.setEditingSupport(editingSupport);
        }
    }

    private void hookColumnResizeListener() {
        if (this.columnResizeListener == null) {
            this.columnResizeListener = new Listener(){

                public void handleEvent(Event event) {
                    boolean autoPreferredSize = false;
                    if (GridViewerColumn.this.viewer instanceof GridTableViewer) {
                        autoPreferredSize = ((GridTableViewer)GridViewerColumn.this.viewer).getAutoPreferredHeight();
                    }
                    if (GridViewerColumn.this.viewer instanceof GridTreeViewer) {
                        autoPreferredSize = ((GridTreeViewer)GridViewerColumn.this.viewer).getAutoPreferredHeight();
                    }
                    if (autoPreferredSize && GridViewerColumn.this.column.getWordWrap()) {
                        Grid grid = GridViewerColumn.this.column.getParent();
                        int cnt = 0;
                        while (cnt < grid.getItemCount()) {
                            grid.getItem(cnt).pack();
                            ++cnt;
                        }
                        grid.redraw();
                    }
                }
            };
            this.column.addListener(11, this.columnResizeListener);
            this.column.addListener(23, this.columnResizeListener);
            this.column.addListener(22, this.columnResizeListener);
        }
    }

    private void unhookColumnResizeListener() {
        if (this.columnResizeListener != null) {
            this.column.removeListener(11, this.columnResizeListener);
            this.columnResizeListener = null;
        }
    }

    private void hookVisibilityListener() {
        this.column.addListener(22, event -> super.setEditingSupport(this.currentEditingSupport));
        this.column.addListener(23, event -> super.setEditingSupport(null));
    }

    protected void handleDispose() {
        this.unhookColumnResizeListener();
        super.handleDispose();
    }
}

