/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.wb.core.branding.BrandingUtils;
import org.eclipse.wb.core.branding.IBrandingDescription;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.errors.report2.CreateReportDialog;
import org.eclipse.wb.internal.core.editor.errors.report2.ZipFileErrorReport;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class ExceptionComposite
extends Composite {
    private Button m_switchButton;
    private BrowserComposite m_browserComposite;
    private Image m_screenshotImage;
    private int m_sourcePosition;
    private final boolean wbBasic = InstanceScope.INSTANCE.getNode("org.eclipse.wb.core.editor.constants.preferences").getBoolean("basicUserInterface", false);

    public ExceptionComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.create(this);
        Composite titleComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)titleComposite).alignHL().grabH();
        GridLayoutFactory.create(titleComposite).columns(2).margins(10);
        Label label = new Label(titleComposite, 0);
        GridDataFactory.create((Control)label).alignVM();
        label.setImage(parent.getDisplay().getSystemImage(1));
        label = new Link(titleComposite, 524352);
        GridDataFactory.create((Control)label).alignHL().grabH().alignVM();
        label.setText(MessageFormat.format(Messages.ExceptionComposite_message, BrandingUtils.getBranding().getProductName()));
        label.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IBrandingDescription branding = BrandingUtils.getBranding();
                String url = null;
                if ("bug tracking system".equals(event.text)) {
                    url = branding.getSupportInfo().getBugtrackingUrl();
                } else if ("discussion group".equals(event.text)) {
                    url = branding.getSupportInfo().getForumUrl();
                }
                if (!StringUtils.isEmpty((CharSequence)url)) {
                    DesignerExceptionUtils.openBrowser(url);
                }
            }
        });
        this.m_browserComposite = new BrowserComposite(this, 0);
        GridDataFactory.create((Control)this.m_browserComposite).grab().alignVF().alignHF();
        Composite buttonsComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)buttonsComposite).alignHR();
        GridLayoutFactory.create(buttonsComposite).columns(3).equalColumns().marginsH(0);
        Button contactSupportButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)contactSupportButton).fillH();
        contactSupportButton.setText(Messages.ExceptionComposite_reportButton);
        contactSupportButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage("actions/errors/support32.png"));
        contactSupportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateReportDialog dialog = new CreateReportDialog(ExceptionComposite.this.getShell(), ExceptionComposite.this.m_screenshotImage, ExceptionComposite.this.getZipFileErrorReport());
                dialog.open();
            }
        });
        contactSupportButton.setVisible(!this.wbBasic);
        Button refreshButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)refreshButton).fillH();
        refreshButton.setText(Messages.ExceptionComposite_reparseButton);
        refreshButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage("actions/errors/refresh32.png"));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionComposite.this.doRefresh();
            }
        });
        refreshButton.setVisible(!this.wbBasic);
        this.m_switchButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)this.m_switchButton).fillH();
        this.m_switchButton.setText(Messages.ExceptionComposite_switchButton);
        this.m_switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ExceptionComposite.this.doShowSource(ExceptionComposite.this.m_sourcePosition);
            }
        });
        this.m_switchButton.setVisible(!this.wbBasic);
        this.addDisposeListener(e -> {
            if (this.m_screenshotImage != null) {
                this.m_screenshotImage.dispose();
            }
        });
    }

    private void updateForSourcePosition(Throwable e) {
        boolean hasSourcePosition;
        this.m_sourcePosition = DesignerExceptionUtils.getSourcePosition(e);
        boolean bl = hasSourcePosition = this.m_sourcePosition != -1;
        if (hasSourcePosition) {
            this.m_switchButton.setText(Messages.ExceptionComposite_goProblemButton);
        } else {
            this.m_switchButton.setText(Messages.ExceptionComposite_switchButton);
        }
        if (!EnvironmentUtils.IS_MAC) {
            Image image = hasSourcePosition ? DesignerPlugin.getImage("actions/errors/switch32locate.png") : DesignerPlugin.getImage("actions/errors/switch32.png");
            this.m_switchButton.setImage(image);
        }
    }

    protected abstract ZipFileErrorReport getZipFileErrorReport();

    protected abstract void doShowSource(int var1);

    protected abstract void doRefresh();

    protected final Image getScreenshotImage() {
        return this.m_screenshotImage;
    }

    protected final void setException0(Throwable e, Image screenshot) {
        this.m_screenshotImage = screenshot;
        this.m_browserComposite.setText(DesignerExceptionUtils.getExceptionHTML(e));
        this.updateForSourcePosition(e);
    }
}

