/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstraintOwner;

public class CPPASTSimpleTypeTemplateParameter
extends ASTNode
implements ICPPASTSimpleTypeTemplateParameter {
    private IASTName fName;
    private IASTTypeId fTypeId;
    private boolean fUsesKeywordClass;
    private boolean fIsParameterPack;
    private TypeConstraintOwner fTypeConstraintOwner = null;

    public CPPASTSimpleTypeTemplateParameter() {
    }

    public CPPASTSimpleTypeTemplateParameter(int type, IASTName name, IASTTypeId typeId) {
        this.fUsesKeywordClass = type == 1;
        this.setName(name);
        this.setDefaultType(typeId);
    }

    @Override
    public CPPASTSimpleTypeTemplateParameter copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTSimpleTypeTemplateParameter copy(IASTNode.CopyStyle style) {
        CPPASTSimpleTypeTemplateParameter copy = new CPPASTSimpleTypeTemplateParameter();
        copy.fUsesKeywordClass = this.fUsesKeywordClass;
        copy.fIsParameterPack = this.fIsParameterPack;
        copy.setName(this.fName == null ? null : this.fName.copy(style));
        copy.setDefaultType(this.fTypeId == null ? null : this.fTypeId.copy(style));
        if (this.fTypeConstraintOwner != null) {
            copy.fTypeConstraintOwner = this.fTypeConstraintOwner.copy(style);
            copy.fTypeConstraintOwner.setParent(copy);
        }
        return this.copy(copy, style);
    }

    @Override
    public boolean isParameterPack() {
        return this.fIsParameterPack;
    }

    @Override
    public void setIsParameterPack(boolean val) {
        this.assertNotFrozen();
        this.fIsParameterPack = val;
    }

    @Override
    public int getParameterType() {
        return this.fUsesKeywordClass ? 1 : 2;
    }

    @Override
    public void setParameterType(int value) {
        this.assertNotFrozen();
        this.fUsesKeywordClass = value == 1;
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(PARAMETER_NAME);
        }
    }

    @Override
    public IASTTypeId getDefaultType() {
        return this.fTypeId;
    }

    @Override
    public void setDefaultType(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(DEFAULT_TYPE);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTemplateParameters) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        if (this.fTypeConstraintOwner != null && !this.fTypeConstraintOwner.accept(action)) {
            return false;
        }
        return !action.shouldVisitTemplateParameters || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.fName) {
            return 0;
        }
        return 3;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public IASTExpression[] getConstraintExpressions() {
        if (this.fTypeConstraintOwner == null) {
            return IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return this.fTypeConstraintOwner.getConstraintExpressions();
    }

    @Override
    public void addConstraintExpression(IASTExpression constraintExpression) {
        if (this.fTypeConstraintOwner == null) {
            this.fTypeConstraintOwner = new TypeConstraintOwner();
            this.fTypeConstraintOwner.setParent(this);
        }
        this.fTypeConstraintOwner.addConstraintExpression(constraintExpression);
    }

    private class TypeConstraintOwner
    extends CPPASTConstraintOwner {
        private TypeConstraintOwner() {
        }

        @Override
        public TypeConstraintOwner copy() {
            return this.copy(IASTNode.CopyStyle.withoutLocations);
        }

        @Override
        public TypeConstraintOwner copy(IASTNode.CopyStyle style) {
            TypeConstraintOwner copy = new TypeConstraintOwner();
            return this.copy(copy, style);
        }

        @Override
        protected <T extends TypeConstraintOwner> T copy(T copy, IASTNode.CopyStyle style) {
            return super.copy(copy, style);
        }
    }
}

