/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class RemoveJPAEntityFeature
extends DefaultRemoveFeature {
    private boolean shouldRearrangeIsARelations = true;

    public RemoveJPAEntityFeature(IFeatureProvider fp, boolean shouldRearrangeIsARelations) {
        super(fp);
        this.shouldRearrangeIsARelations = shouldRearrangeIsARelations;
    }

    public void preRemove(IRemoveContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        HashSet<Shape> shapesForDeletion = new HashSet<Shape>();
        if (bo instanceof PersistentType) {
            PersistentType jpt = (PersistentType)bo;
            JpaArtifactFactory.instance().restoreEntityClass(jpt, this.getFeatureProvider());
            IJPAEditorFeatureProvider fp = this.getFeatureProvider();
            EList lst = ((ContainerShape)pe).getChildren();
            int i = lst.size() - 1;
            while (i >= 0) {
                Shape textShape = (Shape)lst.get(i);
                Object o = fp.getBusinessObjectForPictogramElement((PictogramElement)textShape);
                if (o != null && o instanceof PersistentAttribute) {
                    shapesForDeletion.add(textShape);
                }
                --i;
            }
            Iterator it = shapesForDeletion.iterator();
            while (it.hasNext()) {
                RemoveAttributeFeature f = new RemoveAttributeFeature(fp, false, true);
                RemoveContext ctx = new RemoveContext((PictogramElement)it.next());
                f.remove((IRemoveContext)ctx);
            }
            String name = ((PersistentType)bo).getName();
            this.getFeatureProvider().remove(name, false);
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void execute(IContext ctx) {
        if (!IRemoveContext.class.isInstance(ctx)) {
            return;
        }
        final IRemoveContext context = (IRemoveContext)ctx;
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (!PersistentType.class.isInstance(bo)) {
            return;
        }
        PersistentType jpt = (PersistentType)bo;
        if (JPAEditorUtil.isEntityOpenElsewhere(jpt, true)) {
            String shortEntName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
            String message = NLS.bind((String)JPAEditorMessages.RemoveJPAEntityFeature_discardWarningMsg, (Object)shortEntName);
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPASolver_closeEditors, null, message, 4, new String[]{JPAEditorMessages.BTN_OK, JPAEditorMessages.BTN_CANCEL}, 0){

                protected int getShellStyle() {
                    return 0x10860 | 1.getDefaultOrientation();
                }
            };
            if (dialog.open() != 0) {
                return;
            }
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                RemoveJPAEntityFeature.this.removeEntityFromDiagram(context);
            }
        });
    }

    public void removeEntityFromDiagram(IRemoveContext context) {
        super.execute((IContext)context);
    }

    public void postRemove(IRemoveContext context) {
        if (this.shouldRearrangeIsARelations) {
            JpaArtifactFactory.instance().rearrangeIsARelations(this.getFeatureProvider());
        }
    }
}

