/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteContext;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.tools.RangeSelectionTool;

public class DesignerPaletteRoot
extends PaletteRoot {
    private IPaletteItemManager _manager;
    private IFile _file;
    private IPaletteContext _paletteContext;

    public DesignerPaletteRoot(IFile file) {
        this._paletteContext = PaletteItemManager.createPaletteContext(file);
        this._manager = PaletteItemManager.getInstance(this._paletteContext);
        if (this._manager != null) {
            this.setupBasicItems();
            this.loadItems();
        }
    }

    public IPaletteContext getPaletteContext() {
        return this._paletteContext;
    }

    public IFile getFile() {
        return this._file;
    }

    public IPaletteItemManager getPaletteManager() {
        return this._manager;
    }

    private void setupBasicItems() {
        PaletteGroup controls = new PaletteGroup(PageDesignerResources.getInstance().getString("JSFPalette.DefaultGroup.LabelJSFPallete"));
        this.add((PaletteEntry)controls);
        SelectionToolEntry tool = new SelectionToolEntry(){

            public Tool createTool() {
                return new RangeSelectionTool();
            }
        };
        controls.add((PaletteEntry)tool);
        this.setDefaultEntry((ToolEntry)tool);
        controls.add((PaletteEntry)new MarqueeToolEntry());
    }

    private void loadItems() {
        this.removeItems();
        if (this._manager != null) {
            this.addAll(this._manager.getAllCategories());
        }
    }

    protected void removeItems() {
        ArrayList children1 = new ArrayList(this.getChildren());
        children1.remove(0);
        int i = 0;
        int n = children1.size();
        while (i < n) {
            this.remove((PaletteEntry)children1.get(i));
            ++i;
        }
    }

    public void refresh() {
        this.loadItems();
    }
}

