/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.wizards;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bndtools.templating.Template;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class TemplateParamsWizardPage
extends WizardPage {
    private final Set<String> fixedAttribs = new HashSet<String>();
    private Template template;
    private Composite container;
    private Control currentPanel;
    private boolean skip = false;
    private final Map<String, String> values = new HashMap<String, String>();
    private ObjectClassDefinition ocd;

    public TemplateParamsWizardPage(String[] fixedAttribs) {
        super("templateParams");
        String[] stringArray = fixedAttribs;
        int n = fixedAttribs.length;
        int n2 = 0;
        while (n2 < n) {
            String attrib = stringArray[n2];
            this.fixedAttribs.add(attrib);
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.setTitle("Template Parameters");
        this.setImageDescriptor(Resources.getImageDescriptor("/icons/bndtools-wizban.png"));
        this.container = new Composite(parent, 0);
        this.setControl((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.updateUI();
    }

    public void setTemplate(Template template) {
        this.template = template;
        this.values.clear();
        if (this.container != null && !this.container.isDisposed()) {
            this.updateUI();
        }
    }

    /*
     * Unable to fully structure code
     */
    void updateUI() {
        block12: {
            if (this.currentPanel != null && !this.currentPanel.isDisposed()) {
                this.currentPanel.dispose();
                this.currentPanel = null;
            }
            panel = new Composite(this.container, 0);
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            this.skip = true;
            if (this.template == null) {
                this.setErrorMessage(null);
                this.setMessage("No template is loaded", 2);
            } else {
                layout = new GridLayout(2, false);
                layout.horizontalSpacing = 15;
                panel.setLayout((Layout)layout);
                fieldControls = new LinkedList<Control>();
                try {
                    this.ocd = this.template.getMetadata();
                    count = 0;
                    requiredIds = new HashSet<String>();
                    var9_8 = this.ocd.getAttributeDefinitions(1);
                    var8_10 = var9_8.length;
                    var7_11 = 0;
                    while (var7_11 < var8_10) {
                        ad = var9_8[var7_11];
                        requiredIds.add(ad.getID());
                        ++var7_11;
                    }
                    var10_15 = ads = this.ocd.getAttributeDefinitions(-1);
                    var9_9 = ads.length;
                    var8_10 = 0;
                    while (var8_10 < var9_9) {
                        ad = var10_15[var8_10];
                        attrib = ad.getID();
                        if (!this.fixedAttribs.contains(attrib)) {
                            label = new Label(panel, 0);
                            labelText = ad.getID();
                            if (requiredIds.contains(ad.getID())) {
                                label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
                            }
                            label.setText(labelText);
                            fieldControl = this.createFieldControl(panel, ad);
                            fieldControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                            fieldControls.add(fieldControl);
                            this.skip = false;
                            ++count;
                        }
                        ++var8_10;
                    }
                    if (count == 0) {
                        this.setMessage("No editable parameters for template: " + this.ocd.getName(), 1);
                    } else {
                        this.setMessage("Edit parameters for template: " + this.ocd.getDescription(), 1);
                    }
                    this.setErrorMessage(null);
                    break block12;
                }
                catch (Exception e) {
                    this.setErrorMessage("Error loading template metadata: " + e.getMessage());
                    ** for (fieldControl : fieldControls)
                }
lbl-1000:
                // 1 sources

                {
                    fieldControl.setEnabled(false);
                    continue;
                }
lbl59:
                // 1 sources

                ILog.get().error("Error loading template metadata: ", (Throwable)e);
            }
        }
        this.currentPanel = panel;
        this.container.layout(true, true);
        this.updateValidation();
    }

    private void updateValidation() {
        AttributeDefinition[] ads;
        boolean complete = true;
        AttributeDefinition[] attributeDefinitionArray = ads = this.ocd != null ? this.ocd.getAttributeDefinitions(1) : new AttributeDefinition[]{};
        int n = ads.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition ad = attributeDefinitionArray[n2];
            String adId = ad.getID();
            if (!this.fixedAttribs.contains(adId)) {
                String value = this.values.get(adId);
                String[] defaultValues = ad.getDefaultValue();
                String defaultValue = null;
                if (defaultValues != null && defaultValues.length > 0) {
                    defaultValue = defaultValues[0];
                }
                if (value == null || value.trim().isEmpty()) {
                    complete = false;
                    break;
                }
                boolean toBeReplaced = this.isToBeReplaced(defaultValue);
                if (toBeReplaced && value.equals(defaultValue)) {
                    complete = false;
                    break;
                }
            }
            ++n2;
        }
        this.setPageComplete(complete);
    }

    private Control createFieldControl(Composite parent, AttributeDefinition ad) {
        int textType = 2048;
        switch (ad.getType()) {
            case 12: {
                textType |= 0x400000;
            }
            case 1: 
            case 3: {
                String[] defaultValue;
                Text text = new Text(parent, textType);
                if (ad.getName() != null) {
                    text.setMessage(ad.getName());
                }
                if (ad.getDescription() != null) {
                    ControlDecoration decor = new ControlDecoration((Control)text, 16384, parent);
                    decor.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                    decor.setShowHover(true);
                    decor.setDescriptionText(ad.getDescription());
                    decor.setMarginWidth(5);
                }
                if ((defaultValue = ad.getDefaultValue()) != null && defaultValue.length == 1) {
                    text.setText(defaultValue[0]);
                    this.values.put(ad.getID(), defaultValue[0]);
                }
                text.addModifyListener(ev -> {
                    this.values.put(ad.getID(), text.getText());
                    this.updateValidation();
                });
                return text;
            }
        }
        Label label = new Label(parent, 0);
        label.setText("<Unknown Attribute Type>");
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        return label;
    }

    private boolean isToBeReplaced(String defaultValue) {
        return defaultValue != null && defaultValue.startsWith("<") && defaultValue.endsWith(">");
    }

    public boolean shouldSkip() {
        return this.skip;
    }

    public Map<String, String> getValues() {
        return this.values;
    }
}

