/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;

public class LaunchPluginValidator {
    public static final int DISPLAY_VALIDATION_ERROR_CODE = 1001;

    private static IPluginModelBase[] getSelectedWorkspacePlugins(ILaunchConfiguration configuration) throws CoreException {
        boolean usedefault = configuration.getAttribute("default", true);
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        if (usedefault || models.length == 0) {
            return models;
        }
        Map<IPluginModelBase, String> bundles = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
        Set<IPluginModelBase> result = bundles.keySet();
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public static IProject[] getAffectedProjects(ILaunchConfiguration config) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(config, true);
    }

    public static IProject[] getAffectedProjects(ILaunchConfiguration config, boolean addFeatures) throws CoreException {
        SearchablePluginsManager manager;
        IJavaProject proxy;
        IPluginModelBase[] models;
        if (config.getAttribute("restart", false)) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IPluginModelBase[] iPluginModelBaseArray = models = LaunchPluginValidator.getSelectedWorkspacePlugins(config);
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IProject project = model.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                projects.add(project);
            }
            ++n2;
        }
        if (addFeatures) {
            IProject[] allProjects = PDECore.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < allProjects.length) {
                if (WorkspaceModelManager.isFeatureProject((IProject)allProjects[i]) && !projects.contains(allProjects[i])) {
                    projects.add(allProjects[i]);
                }
                ++i;
            }
        }
        if ((proxy = (manager = PDECore.getDefault().getSearchablePluginsManager()).getProxyProject()) != null) {
            projects.add(proxy.getProject());
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static void runValidationOperation(LaunchValidationOperation op, IProgressMonitor monitor) throws CoreException {
        op.run(monitor);
        if (op.hasErrors()) {
            String message = NLS.bind((String)PDEMessages.PluginValidation_error, (Object)op.getInput().toString());
            Status status = new Status(4, "org.eclipse.pde.launching", 1001, message, null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (statusHandler == null) {
                PDELaunchingPlugin.log((IStatus)status);
            } else {
                statusHandler.handleStatus((IStatus)status, (Object)op);
            }
        }
    }
}

