/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;
import org.eclipse.php.internal.ui.editor.contentassist.IPHPCompletionProposalExtension;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.UseStatementInjector;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionProposal
extends ScriptCompletionProposal
implements IPHPCompletionProposalExtension {
    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Supplier<Image> image, StyledString displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance, false);
    }

    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Supplier<Image> image, StyledString displayString, int relevance, boolean indoc) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance, indoc);
    }

    protected int getPatternMatchRule(String pattern, String string) {
        if (string.length() < pattern.length()) {
            return -1;
        }
        return super.getPatternMatchRule(pattern, string);
    }

    protected boolean isValidPrefix(String prefix) {
        boolean result;
        String word = this.getDisplayString();
        if (word.startsWith("$") && !prefix.startsWith("$")) {
            word = word.substring(1);
        }
        if (!(result = this.isPrefix(prefix, word)) && prefix.length() > 0 && prefix.charAt(0) == '\\') {
            result = this.isPrefix(prefix.substring(1), word);
        }
        if (!result && ProposalExtraInfo.isMemberInNamespace((Object)this.getExtraInfo()) && this.getModelElement() instanceof IType) {
            IType type = (IType)this.getModelElement();
            result = ProposalExtraInfo.isAbsoluteName((Object)this.getExtraInfo()) ? this.isPrefix(prefix.substring(1), PHPModelUtils.getFullName((IType)type)) : this.isPrefix(prefix, PHPModelUtils.getFullName((IType)type));
        }
        if (!result && ProposalExtraInfo.isFullName((Object)this.getExtraInfo()) && this.getModelElement() != null) {
            result = ProposalExtraInfo.isAbsoluteName((Object)this.getExtraInfo()) ? this.isPrefix(prefix.substring(1), PHPModelUtils.getFullName((IModelElement)this.getModelElement())) : this.isPrefix(prefix, PHPModelUtils.getFullName((IModelElement)this.getModelElement()));
        }
        return result;
    }

    protected boolean isSmartTrigger(char trigger) {
        return trigger == '$';
    }

    public void apply(IDocument document, char trigger, int offset) {
        IModelElement modelElement = this.getModelElement();
        boolean activateCodeAssist = false;
        String replacementString = this.getReplacementString();
        if (modelElement instanceof IScriptProject && replacementString.endsWith("/")) {
            activateCodeAssist = true;
        } else {
            IPreferencesService preferencesService = Platform.getPreferencesService();
            boolean enableAutoactivation = preferencesService.getBoolean("org.eclipse.php.core", "contentAssistAutoactivation", false, null);
            if (enableAutoactivation) {
                char lastChar = replacementString.charAt(replacementString.length() - 1);
                char[] cArray = PHPCompletionProcessor.completionAutoActivationChars;
                int n = PHPCompletionProcessor.completionAutoActivationChars.length;
                int n2 = 0;
                while (n2 < n) {
                    char autoActivationChar = cArray[n2];
                    if (autoActivationChar == lastChar) {
                        activateCodeAssist = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (activateCodeAssist) {
            AutoActivationTrigger.register(document);
        }
        UseStatementInjector injector = new UseStatementInjector(this);
        offset = injector.inject(document, this.getTextViewer(), offset);
        super.apply(document, trigger, offset);
        this.setCursorPosition(this.calcCursorPosition());
    }

    private int calcCursorPosition() {
        String replacementString = this.getReplacementString();
        int i = replacementString.lastIndexOf(40);
        if (i != -1) {
            return i + 1;
        }
        i = replacementString.lastIndexOf(39);
        if (i != -1) {
            return i;
        }
        i = replacementString.lastIndexOf(34);
        if (i != -1) {
            return i;
        }
        return replacementString.length();
    }

    public IContextInformation getContextInformation() {
        String displayString = this.getDisplayString();
        if (displayString.indexOf(40) == -1) {
            return null;
        }
        return super.getContextInformation();
    }

    protected boolean isCamelCaseMatching() {
        return true;
    }

    protected boolean insertCompletion() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertCompletion", true, null);
    }

    protected ScriptTextTools getTextTools() {
        return PHPUiPlugin.getDefault().getTextTools();
    }

    @Override
    public Object getExtraInfo() {
        return 1;
    }
}

