/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.nonvisual.ItemCollectorObjectInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class AbstractArrayObjectInfo
extends ItemCollectorObjectInfo {
    public static final String ARRAY_ARBITRARY_KEY = "ARRAY_OBJECT";
    public static final String REMOVE_ON_EMPTY_TAG = "arrayObject.removeOnEmpty";
    public static final String HIDE_IN_TREE_TAG = "arrayObject.hideInTree";
    private final AbstractArrayObjectInfo m_this = this;
    private final Class<?> m_itemType;

    protected AbstractArrayObjectInfo(AstEditor editor, String caption, Class<?> itemType) throws Exception {
        super(editor, caption);
        this.m_itemType = itemType;
    }

    public Class<?> getItemClass() {
        return this.m_itemType;
    }

    @Override
    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            public String getText() {
                Object text = "(array)";
                if (!StringUtils.isEmpty((CharSequence)AbstractArrayObjectInfo.this.m_caption)) {
                    text = AbstractArrayObjectInfo.this.m_caption + (String)text;
                }
                return text;
            }

            public ImageDescriptor getIcon() {
                return CoreImages.FOLDER_OPEN;
            }

            public List<ObjectInfo> getChildrenTree() throws Exception {
                if (AbstractArrayObjectInfo.this.isHideInTree()) {
                    return new LinkedList<ObjectInfo>();
                }
                return AbstractArrayObjectInfo.this.getItems();
            }

            public boolean isVisible() {
                return !AbstractArrayObjectInfo.this.isHideInTree();
            }
        };
    }

    @Override
    protected void addItem(int index, ObjectInfo item) throws Exception {
        super.addItem(index, item);
        if (item != null) {
            item.putArbitraryValue((Object)ARRAY_ARBITRARY_KEY, (Object)this);
        }
    }

    @Override
    protected void removeItem(ObjectInfo item) throws Exception {
        if (((Object)((Object)this.m_this)).equals(item.getArbitraryValue((Object)ARRAY_ARBITRARY_KEY))) {
            item.removeArbitraryValue((Object)ARRAY_ARBITRARY_KEY);
        }
        super.removeItem(item);
    }

    public void command_CREATE(JavaInfo item, JavaInfo nextItem) throws Exception {
        int index;
        JavaInfo parentJavaInfo = this.getParent() instanceof JavaInfo ? (JavaInfo)this.getParent() : null;
        ((ObjectInfoChildAddBefore)this.getBroadcast(ObjectInfoChildAddBefore.class)).invoke(this.getParent(), (ObjectInfo)item, new ObjectInfo[]{nextItem});
        if (parentJavaInfo != null) {
            parentJavaInfo.getBroadcastJava().addBefore(parentJavaInfo, item);
        }
        index = (index = this.m_items.indexOf((Object)nextItem)) == -1 ? this.m_items.size() : index;
        this.getParent().addChild((ObjectInfo)item, (ObjectInfo)nextItem);
        this.addItem(index, item);
        NodeTarget nodeTarget = this.getNodeTarget();
        String source = item.getCreationSupport().add_getSource(nodeTarget);
        Expression element = this.getCreateItemExpression(item, index, AssociationUtils.replaceTemplates(item, source, nodeTarget));
        item.setAssociation(this.getAssociation(element));
        if (parentJavaInfo != null) {
            parentJavaInfo.getBroadcastJava().addAfter(parentJavaInfo, item);
        }
        ((ObjectInfoChildAddAfter)this.getBroadcast(ObjectInfoChildAddAfter.class)).invoke(this.getParent(), (ObjectInfo)item);
    }

    protected Expression getCreateItemExpression(JavaInfo item, int index, String source) throws Exception {
        CreationSupport creationSupport;
        Expression itemExpression = this.createItemExpression(item, index, source);
        item.addRelatedNode((ASTNode)itemExpression);
        if (item.getVariableSupport() == null) {
            item.setVariableSupport(new EmptyVariableSupport(item, itemExpression));
        }
        if ((creationSupport = item.getCreationSupport()) != null && itemExpression instanceof ClassInstanceCreation) {
            creationSupport.add_setSourceExpression(itemExpression);
        }
        return itemExpression;
    }

    protected abstract Expression createItemExpression(JavaInfo var1, int var2, String var3) throws Exception;

    public void command_MOVE(JavaInfo item, JavaInfo nextItem) throws Exception {
        int newIndex;
        JavaInfo parJavaInfo = this.getParent() instanceof JavaInfo ? (JavaInfo)this.getParent() : null;
        JavaInfo oldJavaInfo = item.getParent() instanceof JavaInfo ? item.getParentJava() : null;
        this.getBroadcastObject().childMoveBefore(this.getParent(), (ObjectInfo)item, (ObjectInfo)nextItem);
        if (parJavaInfo != null) {
            parJavaInfo.getBroadcastJava().moveBefore(item, oldJavaInfo, parJavaInfo);
        }
        newIndex = (newIndex = this.m_items.indexOf((Object)nextItem)) == -1 ? this.m_items.size() : newIndex;
        int oldIndex = item.getParent().getChildren().indexOf((Object)item);
        AbstractArrayObjectInfo oldAbstractArrayInfo = AbstractArrayObjectInfo.getArrayObjectInfo(item);
        if (oldAbstractArrayInfo != null) {
            oldIndex = oldAbstractArrayInfo.getItems().indexOf((Object)item);
            int n = oldIndex = oldIndex == -1 ? oldAbstractArrayInfo.getItems().size() : oldIndex;
            if (oldAbstractArrayInfo == this && newIndex > oldIndex) {
                --newIndex;
            }
        }
        Expression element = this.getMoveItemExpression(item, nextItem, oldAbstractArrayInfo, oldIndex, newIndex);
        item.setAssociation(this.getAssociation(element));
        if (parJavaInfo != null) {
            parJavaInfo.getBroadcastJava().moveAfter(item, oldJavaInfo, parJavaInfo);
        }
        this.getBroadcastObject().childMoveAfter(this.getParent(), (ObjectInfo)item, (ObjectInfo)nextItem, oldIndex, newIndex);
    }

    protected abstract Expression getMoveItemExpression(JavaInfo var1, JavaInfo var2, AbstractArrayObjectInfo var3, int var4, int var5) throws Exception;

    protected Expression moveOther(JavaInfo item, JavaInfo nextItem, int newIndex) throws Exception {
        Association association;
        LocalUniqueVariableSupport localVariableSupport;
        if (item.getVariableSupport() instanceof LocalUniqueVariableSupport && (localVariableSupport = (LocalUniqueVariableSupport)item.getVariableSupport()).canInline()) {
            localVariableSupport.inline();
        }
        String source = null;
        if (item.getVariableSupport() instanceof EmptyVariableSupport) {
            source = this.getEditor().getSource((ASTNode)((EmptyVariableSupport)item.getVariableSupport()).getInitializer());
        }
        if ((association = item.getAssociation()) != null && association.remove()) {
            item.setAssociation(null);
        }
        item.getParent().removeChild((ObjectInfo)item);
        this.getParent().addChild((ObjectInfo)item, (ObjectInfo)nextItem);
        this.addItem(newIndex, item);
        if (!(item.getVariableSupport() instanceof EmptyVariableSupport)) {
            item.getVariableSupport().ensureInstanceReadyAt(this.getStatementTarget());
            source = item.getVariableSupport().getReferenceExpression(this.getNodeTarget());
        }
        Assert.isNotNull((Object)source, (String)"No source found for.");
        Expression element = this.getCreateItemExpression(item, newIndex, source);
        return element;
    }

    protected abstract NodeTarget getNodeTarget();

    protected abstract StatementTarget getStatementTarget();

    protected abstract Association getAssociation(Expression var1);

    public static AbstractArrayObjectInfo getArrayObjectInfo(ObjectInfo item) {
        return (AbstractArrayObjectInfo)((Object)item.getArbitraryValue((Object)ARRAY_ARBITRARY_KEY));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption());
        buffer.append(" []");
        return buffer.toString();
    }
}

