/*
 * Copyright 2012-2025 CodeLibs Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.codelibs.nekohtml;

/**
 * Defines an error reporter for reporting HTML errors. There is no such
 * thing as a fatal error in parsing HTML. I/O errors are fatal but should
 * throw an <code>IOException</code> directly instead of reporting an error.
 * <p>
 * When used in a configuration, the error reporter instance should be
 * set as a property with the following property identifier:
 * <pre>
 * "http://cyberneko.org/html/internal/error-reporter" in the
 * </pre>
 * Components in the configuration can query the error reporter using this
 * property identifier.
 * <p>
 * <strong>Note:</strong>
 * All reported errors are within the domain "http://cyberneko.org/html".
 *
 * @author Andy Clark
 *
 * @version $Id: HTMLErrorReporter.java,v 1.4 2005/02/14 03:56:54 andyc Exp $
 */
public interface HTMLErrorReporter {

    //
    // HTMLErrorReporter methods
    //

    /**
     * Formats an error message without reporting the error.
     * 
     * @param key the message key to format
     * @param args arguments to substitute into the message
     * @return the formatted error message
     */
    String formatMessage(String key, Object[] args);

    /**
     * Reports a warning message.
     * 
     * @param key the warning message key
     * @param args arguments to substitute into the message
     */
    void reportWarning(String key, Object[] args);

    /**
     * Reports an error message.
     * 
     * @param key the error message key
     * @param args arguments to substitute into the message
     */
    void reportError(String key, Object[] args);

} // interface HTMLErrorReporter
