/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DeltaDdlGenerator;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDataPreservationDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlGenerator;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlScript;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabaseContainer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModule;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWStorageTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWUserMapping;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWView;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.ManagementType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Alias;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Index;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IndexType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Table;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Trigger;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2UserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.ddl.CoreDdlScriptVector;
import org.eclipse.datatools.enablement.ibm.ddl.CoreDeltaDdlGenerator;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.util.EngineeringOptionID;
import org.eclipse.datatools.enablement.ibm.util.SimpleColumnDetails;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;

public class LUWDeltaDdlGenerator
extends DB2DeltaDdlGenerator
implements IExecutableExtension {
    protected static final int DATA_TYPE = 64;
    protected static final int SCOPE = 128;
    protected static final int IDENTITY = 256;
    protected static final int COMPRESS = 512;
    protected static final int DEFAULT_VALUE = 1024;
    protected static final int NULLABLE = 2048;
    protected static final int LOGGED = 64;
    protected static final int DATA_CAPTURE = 128;
    protected static final int VOLATILE = 256;
    protected static final int COMPRESSION = 512;
    protected static final int APPEND = 1024;
    protected static final int LOCK_SIZE = 2048;
    protected static final int RESTRICT = 4096;
    protected static final int VALUE_COMPRESSION = 8192;
    protected static final int PARTITION_KEY = 16384;
    protected static final int BACKUP = 32768;
    private static final int SCHEMA_OWNERSHIP = 64;
    private static final int TABLESPACE_CONTAINERS = 64;
    private static final int TABLESPACE_AUTORESIZE = 128;
    private static final int TABLESPACE_BUFFERPOOL = 256;
    private static final int TABLESPACE_INCREASESIZE = 512;
    private static final int TABLESPACE_MAXSIZE = 1024;
    private static final int TABLESPACE_PREFETCHSIZE = 2048;
    private static final int TABLESPACE_OVERHEAD = 4096;
    private static final int TABLESPACE_DROPTABLERECOVERY = 8192;
    private static final int TABLESPACE_XFERRATE = 16384;
    private static final int TABLESPACE_CONTAINER_SIZE = 32768;
    protected LUWDdlBuilder builder;
    protected Map columnMap = new LinkedHashMap();
    protected String product;
    protected String version;
    protected IEngineeringCallBack callback;

    public LUWDeltaDdlGenerator() {
        this.builder = new LUWDdlBuilder();
    }

    protected void initDPDdlBuilder() {
        this.dPDdlBuilder = new LUWDataPreservationDdlBuilder();
    }

    protected void setEngineeringCallback(IEngineeringCallBack callback) {
        this.callback = callback;
        this.builder.setEngineeringCallBack(callback);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
        Float.parseFloat(this.version.substring(1));
    }

    public EngineeringOption[] getOptions() {
        if (this.getEngineeringOption() == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
            EngineeringOptionCategory general_options = null;
            EngineeringOptionCategory[] categories = this.getOptionCategories();
            int i = 0;
            while (i < categories.length) {
                if (categories[i].getId().equals("GENERATE_OPTIONS")) {
                    general_options = categories[i];
                }
                ++i;
            }
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            optionVec.add(new EngineeringOption("GENERATE_FULLY_QUALIFIED_NAME", resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), DdlGenerationUtility.getQualifyNamesDefault(), general_options));
            optionVec.add(new EngineeringOption("GENERATE_QUOTED_IDENTIFIER", resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), DdlGenerationUtility.getQuoteIdentifiersDefault(), general_options));
            Object[] options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(options);
            this.setEngineeringOption((EngineeringOption[])options);
        }
        return this.getEngineeringOption();
    }

    public EngineeringOption[] getDdlGeneratorOptionsForDeltaDdl(DDLGenerator ddlGenerator, SQLObject[] sqlObjectsArg) {
        SQLObject[] sqlObjects = new SQLObject[sqlObjectsArg.length];
        int i = 0;
        while (i < sqlObjectsArg.length) {
            sqlObjects[i] = sqlObjectsArg[i] instanceof PrimaryKey ? ((PrimaryKey)sqlObjectsArg[i]).getBaseTable() : (sqlObjectsArg[i] instanceof Column ? ((Column)sqlObjectsArg[i]).getTable() : sqlObjectsArg[i]);
            ++i;
        }
        boolean hasTableSpace = false;
        int i2 = 0;
        while (i2 < sqlObjects.length) {
            if (LUWPackage.eINSTANCE.getLUWTableSpace().isSuperTypeOf(sqlObjects[i2].eClass())) {
                hasTableSpace = true;
                break;
            }
            if (sqlObjects[i2] instanceof LUWDatabase) {
                hasTableSpace = true;
                break;
            }
            ++i2;
        }
        EngineeringOption[] ddlGenOptions = ddlGenerator.getOptions(sqlObjects);
        int i3 = 0;
        while (i3 < ddlGenOptions.length) {
            EngineeringOption option = ddlGenOptions[i3];
            if (option != null) {
                if (option.getId().equals("GENERATE_FULLY_QUALIFIED_NAME")) {
                    option.setBoolean(DdlGenerationUtility.getQualifyNamesDefault());
                } else if (option.getId().equals("GENERATE_QUOTED_IDENTIFIER")) {
                    option.setBoolean(DdlGenerationUtility.getQuoteIdentifiersDefault());
                } else if (option.getId().equals("GENERATE_TABLESPACES")) {
                    option.setBoolean(hasTableSpace);
                }
            }
            ++i3;
        }
        return ddlGenOptions;
    }

    protected boolean shouldExcludeElement(EObject element) {
        if (element instanceof LUWMaterializedQueryTable ? !EngineeringOptionID.generateMQTs((EngineeringOption[])this.selectedOptions) : (element instanceof DB2Table ? ((DB2Table)element).getTemporalTable() != null && !EngineeringOptionID.generateHistoryTable((EngineeringOption[])this.selectedOptions) : (element instanceof DB2Alias ? !EngineeringOptionID.generateAliases((EngineeringOption[])this.selectedOptions) : element instanceof LUWDatabase && !EngineeringOptionID.generateDatabase((EngineeringOption[])this.selectedOptions)))) {
            return true;
        }
        return super.shouldExcludeElement(element);
    }

    protected int getChangeFlag(EObject element, EObject changed, EStructuralFeature feature, FeatureChange setting) {
        if (this.isChangeAnnotationRelated(element, changed, feature)) {
            return 0;
        }
        if (element != changed) {
            if (SQLTablesPackage.eINSTANCE.getColumn().isSuperTypeOf(element.eClass()) && SQLDataTypesPackage.eINSTANCE.getPredefinedDataType().isSuperTypeOf(changed.eClass())) {
                if (this.canAlter((PredefinedDataType)changed)) {
                    return this.getColumnDatatypeChangeFlag((Column)element);
                }
                return 4;
            }
            if (SQLTablesPackage.eINSTANCE.getTable().isSuperTypeOf(element.eClass()) && LUWPackage.eINSTANCE.getLUWPartitionKey().isSuperTypeOf(changed.eClass())) {
                return 16384;
            }
            if (SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(element.eClass()) && !SQLSchemaPackage.eINSTANCE.getSQLObject().isSuperTypeOf(changed.eClass())) {
                return 0;
            }
            if (LUWPackage.eINSTANCE.getLUWTableSpace().isSuperTypeOf(element.eClass()) && LUWPackage.eINSTANCE.getLUWDatabaseContainer().isSuperTypeOf(changed.eClass())) {
                if (!((Object)((Object)((LUWTableSpace)element).getManagementType())).equals((Object)ManagementType.DATABASE_MANAGED_LITERAL)) {
                    return 4;
                }
                if (feature == LUWPackage.eINSTANCE.getLUWDatabaseContainer_SizeInPages() || feature == LUWPackage.eINSTANCE.getLUWDatabaseContainer_Size() || feature == LUWPackage.eINSTANCE.getLUWDatabaseContainer_SizeUnits()) {
                    return 32768;
                }
            }
            return 4;
        }
        if (feature == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            return 8;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Description()) {
            return 16;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Label()) {
            return 32;
        }
        if (feature == LUWPackage.eINSTANCE.getLUWPartitionGroup_Partitions()) {
            return 4;
        }
        if (feature == LUWPackage.eINSTANCE.getLUWBufferPool_PartitionGroup()) {
            return 4;
        }
        if (feature == LUWPackage.eINSTANCE.getLUWBufferPool_SizeException()) {
            return 4;
        }
        if (element instanceof LUWTableSpace) {
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_Containers()) {
                EList oldContainers = (EList)this.getOldValue(feature, element);
                EList newContainers = ((LUWTableSpace)element).getContainers();
                if (((Object)((Object)((LUWTableSpace)element).getManagementType())).equals((Object)ManagementType.DATABASE_MANAGED_LITERAL) && newContainers != null && oldContainers != null) {
                    return 64;
                }
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_AutoResize()) {
                if (((LUWTableSpace)element).isAutoResize()) {
                    return 1664;
                }
                return 128;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_BufferPool()) {
                return 256;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_IncreaseSize() || feature == LUWPackage.eINSTANCE.getLUWTableSpace_IncreasePercent() || feature == LUWPackage.eINSTANCE.getLUWTableSpace_IncreaseSizeUnit()) {
                return 512;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_MaximumSize() || feature == LUWPackage.eINSTANCE.getLUWTableSpace_MaximumSizeUnit()) {
                return 1024;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_Overhead()) {
                return 4096;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_PreFetchSize()) {
                return 2048;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_RecoverDroppedTableOn()) {
                return 8192;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTableSpace_TransferRate()) {
                return 16384;
            }
            return 4;
        }
        if (SQLTablesPackage.eINSTANCE.getColumn().isSuperTypeOf(element.eClass())) {
            Column column = (Column)element;
            if (feature == SQLTablesPackage.eINSTANCE.getColumn_DefaultValue()) {
                return 1024;
            }
            if (feature == SQLTablesPackage.eINSTANCE.getColumn_Nullable()) {
                return this.getColumnNullableChangeFlag(column);
            }
            if (feature == SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType()) {
                PredefinedDataType type2 = (PredefinedDataType)column.getContainedType();
                if (type2 == null) {
                    return 4;
                }
                PredefinedDataType type1 = (PredefinedDataType)this.getOldValue((EStructuralFeature)SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType(), (EObject)column);
                if (type1 == null) {
                    return 4;
                }
                if (this.canAlter(type1, type2)) {
                    return this.getColumnDatatypeChangeFlag(column);
                }
                return 4;
            }
        }
        if (SQLTablesPackage.eINSTANCE.getTable().isSuperTypeOf(element.eClass())) {
            if (feature == LUWPackage.eINSTANCE.getLUWStorageTable_PartitionKey()) {
                return 16384;
            }
            if (feature == DB2ModelPackage.eINSTANCE.getDB2Table_DataCapture()) {
                return 128;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWStorageTable_RowCompression()) {
                return 512;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWStorageTable_ValueCompression()) {
                return 8192;
            }
            if (feature == LUWPackage.eINSTANCE.getLUWTable_Volatile()) {
                return 256;
            }
            int columnsFlag = this.getColumnsChangeFlag(element, feature);
            if (columnsFlag != 0) {
                return columnsFlag;
            }
        }
        if (SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(element.eClass()) && feature == SQLSchemaPackage.eINSTANCE.getSchema_Owner() && this.isTransferOwnershipSupported()) {
            return 64;
        }
        if (changed instanceof DB2Table && feature == SQLTablesPackage.eINSTANCE.getTable_Index() && this.isDimensionsChanged((List)changed.eGet(feature), (List)setting.getValue())) {
            return 4;
        }
        if (feature instanceof EReference && feature.isMany() && ((EReference)feature).getEOpposite() != null) {
            return 0;
        }
        return 4;
    }

    private boolean isDimensionsChanged(List curIndexList, List preIndexList) {
        HashSet curDimensions = new HashSet();
        HashSet preDimensions = new HashSet();
        for (Object e : curIndexList) {
            if (!(e instanceof DB2Index) || ((DB2Index)e).getIndexType() != DB2IndexType.DIMENSION_LITERAL) continue;
            curDimensions.add(e);
        }
        for (Object e : preIndexList) {
            if (!(e instanceof DB2Index) || ((DB2Index)e).getIndexType() != DB2IndexType.DIMENSION_LITERAL) continue;
            preDimensions.add(e);
        }
        return curDimensions.size() != preDimensions.size() || !curDimensions.containsAll(preDimensions);
    }

    protected boolean isTransferOwnershipSupported() {
        return false;
    }

    protected int getColumnDatatypeChangeFlag(Column column) {
        return 64;
    }

    protected int getColumnNullableChangeFlag(Column column) {
        return 4;
    }

    protected boolean containsXMLColumn(LUWTable table) {
        return false;
    }

    protected boolean needRecreate(EObject e, int flag) {
        if (SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(e.eClass())) {
            return (flag & 4) != 0;
        }
        return (flag & 0xC) != 0;
    }

    protected void analyze(Map changeMap) {
        LinkedList columns = new LinkedList();
        for (Object e : changeMap.keySet()) {
            if (!(e instanceof Column)) continue;
            columns.add(e);
        }
        Iterator<Object> it = columns.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            int n = (Integer)changeMap.get(column);
            if (n == 2) {
                if (!this.analyzeDropColumnAndContinue(column, changeMap, it)) continue;
                continue;
            }
            Table table = column.getTable();
            if (!LUWPackage.eINSTANCE.getLUWTable().isSuperTypeOf(table.eClass()) || LUWPackage.eINSTANCE.getLUWNickname().isSuperTypeOf(table.eClass()) || (n & 0xC) == 0) continue;
            changeMap.remove(column);
            it.remove();
            n = 0;
            if (changeMap.containsKey(table)) {
                n = (Integer)changeMap.get(table);
            }
            changeMap.put(table, n |= 4);
        }
        for (Column column : columns) {
            if (this.isAncestorModified(changeMap, (EObject)column)) {
                changeMap.remove(column);
                continue;
            }
            int n = (Integer)changeMap.get(column);
            changeMap.remove(column);
            this.columnMap.put(column, n);
        }
        super.analyze(changeMap);
        it = changeMap.keySet().iterator();
        LinkedList<Object> indexes = new LinkedList<Object>();
        while (it.hasNext()) {
            Object object = it.next();
            int flag2 = (Integer)changeMap.get(object);
            if (!(object instanceof DB2Index) || ((DB2Index)object).getIndexType() != DB2IndexType.DIMENSION_LITERAL || (flag2 & 3) == 0) continue;
            indexes.add(object);
        }
        for (DB2Index dB2Index : indexes) {
            int flag3 = (Integer)changeMap.get(dB2Index);
            Table table = null;
            if (flag3 == 2) {
                this.undo();
                table = dB2Index.getTable();
                this.redo();
            } else {
                table = dB2Index.getTable();
            }
            changeMap.put(table, 3);
            changeMap.remove(dB2Index);
        }
        for (Object object : changeMap.keySet()) {
            int flag4;
            if (!(object instanceof PersistentTable) || ((flag4 = ((Integer)changeMap.get(object)).intValue()) & 3) != 3) continue;
            flag4 &= 0xFFFFFFFD;
            changeMap.put(object, flag4 |= 0x8000);
        }
        this.removeRedundantColumnChange(changeMap, this.columnMap);
    }

    protected void removeRedundantColumnChange(Map changeMap, Map colMap) {
        Iterator it = colMap.keySet().iterator();
        Table table = null;
        while (it.hasNext()) {
            EObject obj;
            Column column = (Column)it.next();
            int flag = (Integer)colMap.get(column);
            table = flag == 2 ? ((obj = ((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column)) != null && SQLTablesPackage.eINSTANCE.getTable().isSuperTypeOf(obj.eClass()) ? (Table)((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column) : column.getTable()) : column.getTable();
            if (table == null) {
                table = column.getTable();
            }
            if (table == null || !LUWPackage.eINSTANCE.getLUWTable().isSuperTypeOf(table.eClass()) || LUWPackage.eINSTANCE.getLUWNickname().isSuperTypeOf(table.eClass()) || !changeMap.containsKey(table) || ((flag = ((Integer)changeMap.get(table)).intValue()) & 0x8002) == 0) continue;
            it.remove();
        }
    }

    protected boolean isRenameTableSupported() {
        return true;
    }

    protected boolean analyzeDropColumnAndContinue(Column column, Map changeMap, Iterator it) {
        Table table = (Table)((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column);
        if (LUWPackage.eINSTANCE.getLUWTable().isSuperTypeOf(table.eClass()) && !LUWPackage.eINSTANCE.getLUWNickname().isSuperTypeOf(table.eClass())) {
            changeMap.remove(column);
            it.remove();
            int flag = 0;
            if (changeMap.containsKey(table) && (flag = ((Integer)changeMap.get(table)).intValue()) == 2) {
                return true;
            }
            changeMap.put(table, flag |= 4);
            return true;
        }
        return false;
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor) {
        DDLGenerator ddlGenerator = this.getDdlGeneratorWithDeltaDDLOptions();
        this.undo();
        String[] drops = new String[]{};
        if (EngineeringOptionID.generateDropStatement((EngineeringOption[])this.selectedOptions)) {
            drops = this.getDropStatements(ddlGenerator, changeMap, monitor, this.callback);
        }
        String[] backups = this.getBackupStatements(ddlGenerator, changeMap, monitor);
        Map backupTables = this.getBackupTableMetadata(changeMap);
        this.redo();
        if (!backupTables.isEmpty()) {
            this.dataPreservationRequired = true;
        }
        String[] tableAlters = new String[]{};
        if (EngineeringOptionID.generateTables((EngineeringOption[])this.selectedOptions)) {
            tableAlters = this.getTableAlterStatements(ddlGenerator, changeMap, monitor);
        }
        String[] renames = this.getRenameStatements(ddlGenerator, changeMap, monitor);
        String[] creates = new String[]{};
        if (EngineeringOptionID.generateCreateStatement((EngineeringOption[])this.selectedOptions)) {
            creates = this.getCreateStatements(ddlGenerator, changeMap, monitor, this.callback);
        }
        String[] pops = this.getPopulateStatements(ddlGenerator, changeMap, backupTables, monitor);
        String[] dropbackups = this.getDropBackupStatements(ddlGenerator, changeMap, backupTables, monitor);
        String[] xferO = this.getTransferOwnershipStatements(changeMap);
        String[] ats = new String[]{};
        if (EngineeringOptionID.generateTablespaces((EngineeringOption[])this.selectedOptions)) {
            ats = this.getAlterTablespaceStatements(changeMap);
        }
        String[] ac = new String[]{};
        if (EngineeringOptionID.generateTables((EngineeringOption[])this.selectedOptions)) {
            ac = this.getAlterColumnStatements(this.columnMap);
        }
        this.changeDescription = null;
        try {
            for (Object e : this.columnMap.keySet()) {
                int flag = (Integer)this.columnMap.get(e);
                if (!(e instanceof Column) || (flag & 0x10) == 0) continue;
                changeMap.put(e, 16);
            }
        }
        finally {
            this.columnMap.clear();
        }
        String[] comments = new String[]{};
        if (EngineeringOptionID.generateCommentStatement((EngineeringOption[])this.selectedOptions)) {
            comments = this.getCommentOnStatements(changeMap);
        }
        String[] script = this.merge(this.merge(this.merge(this.merge(this.merge(this.merge(this.merge(this.merge(this.merge(this.merge(drops, backups), renames), ac), tableAlters), ats), xferO), creates), pops), dropbackups), comments);
        return script;
    }

    private String[] getTransferOwnershipStatements(Map changeMap) {
        boolean quoteIdentifiers = EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions());
        EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions());
        Vector<String> stmts = new Vector<String>();
        for (EObject changed : changeMap.keySet()) {
            String statement;
            int flag;
            if (!(changed instanceof Schema) || !EngineeringOptionID.generateSchemas((EngineeringOption[])this.selectedOptions) || ((flag = ((Integer)changeMap.get(changed)).intValue()) & 0x40) == 0 || (statement = this.builder.transferSchemaOwnership((Schema)changed, quoteIdentifiers)) == null) continue;
            stmts.add(statement);
        }
        CoreDdlScriptVector sorter = new CoreDdlScriptVector();
        sorter.addAll(stmts);
        Object[] s = new String[sorter.size()];
        sorter.copyInto(s);
        return s;
    }

    private String[] getAlterTablespaceStatements(Map changeMap) {
        boolean quoteIdentifiers = EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions());
        boolean qualifyNames = EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions());
        Vector<String> alts = new Vector<String>();
        for (EObject changed : changeMap.keySet()) {
            EList newContainers;
            EList oldContainers;
            EReference feature;
            LUWTableSpace tablespace;
            int flag;
            if (!(changed instanceof LUWTableSpace) || ((flag = ((Integer)changeMap.get(changed)).intValue()) & 0xFFFFFFF4) == 0) continue;
            String statement = this.builder.alterTablespaceProlog((LUWTableSpace)changed, quoteIdentifiers, qualifyNames);
            if ((flag & 0x40) != 0) {
                tablespace = (LUWTableSpace)changed;
                feature = LUWPackage.eINSTANCE.getLUWTableSpace_Containers();
                oldContainers = (EList)this.getOldValue((EStructuralFeature)feature, (EObject)tablespace);
                newContainers = tablespace.getContainers();
                statement = String.valueOf(statement) + this.builder.alterTablespaceContainers((LUWTableSpace)changed, newContainers, oldContainers, quoteIdentifiers, qualifyNames);
            }
            if ((flag & 0x8000) != 0) {
                tablespace = (LUWTableSpace)changed;
                feature = LUWPackage.eINSTANCE.getLUWTableSpace_Containers();
                oldContainers = (EList)this.getOldValue((EStructuralFeature)feature, (EObject)tablespace);
                newContainers = tablespace.getContainers();
                statement = String.valueOf(statement) + this.builder.alterTablespaceContainersSize((LUWTableSpace)changed, newContainers, oldContainers, quoteIdentifiers, qualifyNames, this);
            }
            if ((flag & 0x800) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespacePrefetchSizeClause((LUWTableSpace)changed);
            }
            if ((flag & 0x100) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceBufferPoolClause((LUWTableSpace)changed, quoteIdentifiers);
            }
            if ((flag & 0x1000) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceOverheadClause((LUWTableSpace)changed);
            }
            if ((flag & 0x4000) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceXferRateClause((LUWTableSpace)changed);
            }
            if ((flag & 0x2000) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceDroppedTableRecoveryClause((LUWTableSpace)changed);
            }
            if ((flag & 0x80) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceAutoResizeClause((LUWTableSpace)changed);
            }
            if ((flag & 0x200) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceIncreaseSizeClause((LUWTableSpace)changed);
            }
            if ((flag & 0x400) != 0) {
                statement = String.valueOf(statement) + this.builder.tablespaceMaxSizeClause((LUWTableSpace)changed);
            }
            if (statement == null) continue;
            alts.add(statement);
        }
        Object[] s = new String[alts.size()];
        alts.copyInto(s);
        return s;
    }

    protected String[] getDropStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor, IEngineeringCallBack callback) {
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0 || (flag & 1) == 0 || !LUWPackage.eINSTANCE.getLUWTableSpace().isSuperTypeOf(key.eClass())) continue;
            this.setDestructive(true);
        }
        return super.getDropStatements(gen, changeMap, monitor, callback);
    }

    protected final String[] getBackupStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        if (!(gen instanceof LUWDdlGenerator)) {
            return new String[0];
        }
        Vector<EObject> elements = new Vector<EObject>();
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 0x8000) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            return this.backupTableStatements((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions()), monitor, 100);
        }
        return new String[0];
    }

    protected final String[] getRenameStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        if (!(gen instanceof LUWDdlGenerator)) {
            return new String[0];
        }
        Vector<EObject> elements = new Vector<EObject>();
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 8) == 0 || (flag & 2) != 0 || this.shouldExcludeElement(key)) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            String[] renames = this.renameTableStatements((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions()), monitor, 100);
            return this.merge(renames, this.renameTableSpaceStatements((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions()), monitor, 100));
        }
        return new String[0];
    }

    protected Map getBackupTableMetadata(Map changeMap) {
        HashMap ret = new HashMap();
        for (EObject key : changeMap.keySet()) {
            int flag;
            if (!SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(key.eClass()) || ((flag = ((Integer)changeMap.get(key)).intValue()) & 0x8000) == 0) continue;
            HashMap<Column, SimpleColumnDetails> columnMap = new HashMap<Column, SimpleColumnDetails>();
            for (Column col : ((Table)key).getColumns()) {
                SimpleColumnDetails details = new SimpleColumnDetails(col);
                columnMap.put(col, details);
            }
            ret.put(key, columnMap);
        }
        return ret;
    }

    protected final String[] getPopulateStatements(DDLGenerator gen, Map changeMap, Map backupMetadata, IProgressMonitor monitor) {
        if (!(gen instanceof LUWDdlGenerator)) {
            return new String[0];
        }
        Vector<EObject> newTables = new Vector<EObject>();
        Vector<String> oldTableNames = new Vector<String>();
        Vector<Map> oldTableColumns = new Vector<Map>();
        for (EObject key : changeMap.keySet()) {
            if (!SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(key.eClass())) continue;
            String oldTableName = (String)this.getOldValue(key.eClass().getEStructuralFeature("name"), key);
            int flag = (Integer)changeMap.get(key);
            if ((flag & 0x8000) == 0) continue;
            boolean canPopulate = true;
            Map oldColumns = (Map)backupMetadata.get(key);
            if (!canPopulate) continue;
            newTables.add(key);
            oldTableNames.add(oldTableName);
            oldTableColumns.add(oldColumns);
        }
        if (newTables.size() > 0) {
            Object[] newTableArray = new Table[newTables.size()];
            newTables.copyInto(newTableArray);
            Object[] oldTableNameArray = new String[oldTableNames.size()];
            oldTableNames.copyInto(oldTableNameArray);
            Object[] oldTableColumnsArray = new Map[oldTableColumns.size()];
            oldTableColumns.copyInto(oldTableColumnsArray);
            return this.populateFromBackupTableStatements((Table[])newTableArray, (String[])oldTableNameArray, (Map[])oldTableColumnsArray, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions()), monitor, 100);
        }
        return new String[0];
    }

    protected String[] backupTableStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        LUWDdlScript script = new LUWDdlScript();
        LUWDataPreservationDdlBuilder dpBuilder = (LUWDataPreservationDdlBuilder)this.getDPDdlBuilder();
        for (Object o : DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elements)) {
            String statement;
            if (!(o instanceof DB2Table) || (statement = dpBuilder.renameTableToBackup((Table)((DB2Table)o), quoteIdentifiers, qualifyNames)) == null) continue;
            script.addBackupTableStatement(dpBuilder.getRenameComment());
            script.addBackupTableStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] renameTableStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        LUWDdlScript script = new LUWDdlScript();
        for (Object o : DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elements)) {
            Object oldName;
            String statement;
            if (!(o instanceof DB2Table) || (statement = this.builder.renameTable((Table)((DB2Table)o), (String)(oldName = this.getOldValue((EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), (EObject)o)), quoteIdentifiers, qualifyNames)) == null) continue;
            script.addRenameTableStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] renameTableSpaceStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        LUWDdlScript script = new LUWDdlScript();
        for (Object o : DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elements)) {
            Object oldName;
            String statement;
            if (!(o instanceof LUWTableSpace) || (statement = this.builder.alterTablespaceRename((LUWTableSpace)o, (String)(oldName = this.getOldValue((EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), (EObject)o)), quoteIdentifiers, qualifyNames)) == null) continue;
            script.addRenameTableStatement(statement);
        }
        return script.getStatements();
    }

    public String[] populateFromBackupTableStatements(Table[] tables, String[] oldTableNames, Map[] oldColumnMaps, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        LUWDdlScript script = new LUWDdlScript();
        LUWDataPreservationDdlBuilder dpBuilder = (LUWDataPreservationDdlBuilder)this.getDPDdlBuilder();
        int i = 0;
        while (i < tables.length) {
            ArrayList genColumns = dpBuilder.getAlwaysGeneratedColumns(tables[i]);
            Iterator it = genColumns.iterator();
            while (it.hasNext()) {
                Column genColumn = (Column)it.next();
                if (oldColumnMaps[i].get(genColumn) == null) {
                    it.remove();
                    continue;
                }
                script.addPopulateTableStatement(dpBuilder.getSuspendGenerateAlwaysStatement(tables[i], genColumn, quoteIdentifiers, qualifyNames));
            }
            String statement = dpBuilder.populateTableFromBackup(tables[i], oldTableNames[i], oldColumnMaps[i], quoteIdentifiers, qualifyNames);
            if (statement != null) {
                script.addPopulateTableStatement(dpBuilder.getPopulateComment());
                script.addPopulateTableStatement(statement);
            }
            for (Column genColumn : genColumns) {
                if (genColumn.getIdentitySpecifier() != null) {
                    script.addPopulateTableStatement(dpBuilder.getRestartIdentityComment());
                    script.addPopulateTableStatement(dpBuilder.getRestartIdentityStatement(tables[i], genColumn, quoteIdentifiers, qualifyNames));
                }
                script.addPopulateTableStatement(dpBuilder.getSetGenerateAlwaysStatement(tables[i], genColumn, quoteIdentifiers, qualifyNames));
            }
            ++i;
        }
        return script.getStatements();
    }

    protected final String[] getDropBackupStatements(DDLGenerator gen, Map changeMap, Map backupMetadata, IProgressMonitor monitor) {
        if (!(gen instanceof LUWDdlGenerator)) {
            return new String[0];
        }
        Vector<EObject> elements = new Vector<EObject>();
        for (EObject key : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(key);
            if ((flag & 0x8000) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            return this.dropBackupTableStatements((SQLObject[])d, EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions()), EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions()), monitor, 100);
        }
        return new String[0];
    }

    protected String[] dropBackupTableStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        LUWDdlScript script = new LUWDdlScript();
        LUWDataPreservationDdlBuilder dpBuilder = (LUWDataPreservationDdlBuilder)this.getDPDdlBuilder();
        for (Object o : DdlGenerationUtility.getAllContainedDisplayableElementSet((SQLObject[])elements)) {
            String oldTableName;
            Schema oldSchema;
            String oldSchemaName;
            String statement;
            if (!(o instanceof DB2Table) || (statement = dpBuilder.dropBackupTable(oldSchemaName = (oldSchema = (Schema)this.getOldValue(((DB2Table)o).eClass().getEStructuralFeature("schema"), (EObject)((DB2Table)o))) != null ? oldSchema.getName() : "", oldTableName = (String)this.getOldValue(((DB2Table)o).eClass().getEStructuralFeature("name"), (EObject)((DB2Table)o)), quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropBackupTableStatement(dpBuilder.getDropBackupComment());
            script.addDropBackupTableStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] getTableAlterStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        boolean quoteIdentifiers = EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions());
        boolean qualifyNames = EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions());
        Vector<String> alts = new Vector<String>();
        for (Object obj : changeMap.keySet()) {
            String statement;
            if (!(obj instanceof Table)) continue;
            Table table = (Table)obj;
            int flag = (Integer)changeMap.get(table);
            if (flag == 16384 && (statement = this.builder.alterTableAlterPartitionKey((LUWStorageTable)table, quoteIdentifiers, qualifyNames)) != null) {
                alts.add(statement);
            }
            if ((flag & 0x8000) != 0 || (flag & 0x2380) == 0 || (statement = this.builder.alterTableAlterProperties(table, flag, quoteIdentifiers, qualifyNames)) == null) continue;
            alts.add(statement);
        }
        CoreDdlScriptVector sorter = new CoreDdlScriptVector();
        sorter.addAll(alts);
        Object[] s = new String[sorter.size()];
        sorter.copyInto(s);
        return s;
    }

    protected String[] getAlterColumnStatements(Map changeMap) {
        boolean quoteIdentifiers = EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions());
        boolean qualifyNames = EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions());
        TreeMap<String, Vector<String>> statementsByTable = new TreeMap<String, Vector<String>>();
        HashMap<Table, Integer> reorgMap = new HashMap<Table, Integer>();
        for (Column column : changeMap.keySet()) {
            Table table;
            String statement;
            int flag = (Integer)changeMap.get(column);
            if (flag == 1 && EngineeringOptionID.generateCreateStatement((EngineeringOption[])this.selectedOptions)) {
                String statement3;
                String statement2;
                String statement1;
                if (((LUWColumn)column).getGenerateExpression() != null && (statement1 = this.builder.setIntegrityForTableBeforeAlter(column, quoteIdentifiers, qualifyNames)) != null) {
                    this.addStatementToTableSortedMap(statementsByTable, column, statement1, false);
                }
                if ((statement2 = this.builder.alterTableAddColumn(column, quoteIdentifiers, qualifyNames)) != null) {
                    this.addStatementToTableSortedMap(statementsByTable, column, statement2, false);
                }
                if (((LUWColumn)column).getGenerateExpression() == null || (statement3 = this.builder.setIntegrityForTableAfterAlter(column, quoteIdentifiers, qualifyNames)) == null) continue;
                this.addStatementToTableSortedMap(statementsByTable, column, statement3, false);
                continue;
            }
            if (flag == 2 && EngineeringOptionID.generateDropStatement((EngineeringOption[])this.selectedOptions)) {
                statement = this.builder.alterTableDropColumn(column, quoteIdentifiers, qualifyNames, (CoreDeltaDdlGenerator)this);
                if (statement == null) continue;
                this.addStatementToTableSortedMap(statementsByTable, column, statement, true);
                table = this.getOldContainer(column);
                if (table == null || (statement = this.reorgIfRequired(reorgMap, table, quoteIdentifiers, qualifyNames)) == null) continue;
                this.addStatementToTableSortedMap(statementsByTable, column, statement, true);
                continue;
            }
            if ((flag & 0x40) != 0 && (statement = this.builder.alterTableAlterColumnDataType(column, quoteIdentifiers, qualifyNames)) != null) {
                this.addStatementToTableSortedMap(statementsByTable, column, statement, false);
                table = column.getTable();
                if (table != null && (statement = this.reorgIfRequired(reorgMap, table, quoteIdentifiers, qualifyNames)) != null) {
                    this.addStatementToTableSortedMap(statementsByTable, column, statement, false);
                }
            }
            if ((flag & 0x400) != 0 && (statement = this.builder.alterTableAlterColumnDefaultValue(column, quoteIdentifiers, qualifyNames)) != null) {
                this.addStatementToTableSortedMap(statementsByTable, column, statement, false);
            }
            if ((flag & 0x800) == 0 || (statement = this.builder.alterTableAlterColumnNullable(column, quoteIdentifiers, qualifyNames)) == null) continue;
            this.addStatementToTableSortedMap(statementsByTable, column, statement, false);
            table = column.getTable();
            if (table == null || (statement = this.reorgIfRequired(reorgMap, table, quoteIdentifiers, qualifyNames)) == null) continue;
            this.addStatementToTableSortedMap(statementsByTable, column, statement, false);
        }
        Set tablesToReorg = reorgMap.keySet();
        for (Table table : tablesToReorg) {
            String statement = this.builder.reorgTable(table, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            this.addStatementToTableSortedMap(statementsByTable, table, statement);
        }
        reorgMap.clear();
        Vector alts = new Vector();
        Iterator iterator = statementsByTable.keySet().iterator();
        while (iterator.hasNext()) {
            Vector stmts = (Vector)statementsByTable.get((String)iterator.next());
            alts.addAll(stmts);
            stmts.clear();
        }
        statementsByTable.clear();
        Object[] s = new String[alts.size()];
        alts.copyInto(s);
        return s;
    }

    protected void addStatementToTableSortedMap(Map<String, Vector<String>> statementsByTable, Column column, String statement, boolean getOldTable) {
        if (statement != null) {
            Table table = null;
            if (getOldTable) {
                table = (Table)((ChangeDescriptionImpl)this.changeDescription).getOldContainer((EObject)column);
            }
            if (table == null) {
                table = column.getTable();
            }
            this.addStatementToTableSortedMap(statementsByTable, table, statement);
        }
    }

    protected void addStatementToTableSortedMap(Map<String, Vector<String>> statementsByTable, Table table, String statement) {
        Schema schema = table.getSchema();
        String schemaName = schema == null ? "" : table.getSchema().getName();
        String tableName = String.valueOf(schemaName) + "." + table.getName();
        if (statement != null) {
            if (!statementsByTable.containsKey(tableName)) {
                statementsByTable.put(tableName, new Vector());
            }
            Vector<String> stmts = statementsByTable.get(tableName);
            stmts.add(statement);
            statementsByTable.put(tableName, stmts);
        }
    }

    private String reorgIfRequired(Map<Table, Integer> reorgMap, Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        int cnt = 1;
        if (reorgMap.containsKey(table)) {
            cnt = reorgMap.get(table);
            if (++cnt >= 3) {
                reorgMap.remove(table);
                return this.builder.reorgTable(table, quoteIdentifiers, qualifyNames);
            }
        }
        reorgMap.put(table, cnt);
        return null;
    }

    protected String[] getCommentOnStatements(Map changeMap) {
        boolean quoteIdentifiers = EngineeringOptionID.generateQuotedIdentifiers((EngineeringOption[])this.getSelectedOptions());
        boolean qualifyNames = EngineeringOptionID.generateFullyQualifiedNames((EngineeringOption[])this.getSelectedOptions());
        Vector<String> comments = new Vector<String>();
        for (EObject o : changeMap.keySet()) {
            int flag = (Integer)changeMap.get(o);
            if (this.shouldExcludeElement(o) || (flag & 0x11) == 0 && (!SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(o.eClass()) || (flag & 8) == 0)) continue;
            String statement = null;
            if (LUWPackage.eINSTANCE.getLUWNickname().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWNickname)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWServer().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWServer)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWWrapper().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWWrapper)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWUserMapping().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWUserMapping)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWMaterializedQueryTable().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Table)((LUWMaterializedQueryTable)o), quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWTable().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Table)((LUWTable)o), quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWTableSpace().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWTableSpace)o, quoteIdentifiers);
            } else if (LUWPackage.eINSTANCE.getLUWView().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Table)((LUWView)o), quoteIdentifiers, qualifyNames);
            } else if (DB2ModelPackage.eINSTANCE.getDB2Alias().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((DB2Alias)o, quoteIdentifiers, qualifyNames);
            } else if (DB2ModelPackage.eINSTANCE.getDB2Procedure().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Procedure)((DB2Procedure)o), quoteIdentifiers, qualifyNames);
            } else if (DB2ModelPackage.eINSTANCE.getDB2UserDefinedFunction().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((UserDefinedFunction)((DB2UserDefinedFunction)o), quoteIdentifiers, qualifyNames);
            } else if (DB2ModelPackage.eINSTANCE.getDB2Trigger().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Trigger)((DB2Trigger)o), quoteIdentifiers, qualifyNames);
            } else if (SQLConstraintsPackage.eINSTANCE.getCheckConstraint().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames);
            } else if (SQLConstraintsPackage.eINSTANCE.getUniqueConstraint().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames);
            } else if (SQLConstraintsPackage.eINSTANCE.getForeignKey().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames);
            } else if (DB2ModelPackage.eINSTANCE.getDB2Index().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Index)((DB2Index)o), quoteIdentifiers, qualifyNames);
            } else if (SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((DistinctUserDefinedType)o, quoteIdentifiers, qualifyNames);
            } else if (SQLTablesPackage.eINSTANCE.getColumn().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Column)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWPartitionGroup().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWPartitionGroup)o, quoteIdentifiers);
            } else if (SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Schema)o, quoteIdentifiers, qualifyNames);
            } else if (SQLAccessControlPackage.eINSTANCE.getRole().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((Role)o, quoteIdentifiers, qualifyNames);
            } else if (LUWPackage.eINSTANCE.getLUWModule().isSuperTypeOf(o.eClass())) {
                statement = this.builder.commentOn((LUWModule)o, quoteIdentifiers, qualifyNames);
            }
            if (statement == null) continue;
            comments.add(statement);
        }
        CoreDdlScriptVector sorter = new CoreDdlScriptVector();
        sorter.addAll(comments);
        Object[] s = new String[sorter.size()];
        sorter.copyInto(s);
        return s;
    }

    protected boolean canAlter(String type1, String type2, int length1, int length2, int scale1, int scale2) {
        if (type1.equals("SMALLINT")) {
            if (type2.equals("SMALLINT")) {
                return true;
            }
            if (type2.equals("INTEGER")) {
                return true;
            }
            if (type2.equals("BIGINT")) {
                return true;
            }
            if (type2.equals("FLOAT")) {
                return true;
            }
            if (type2.equals("DOUBLE")) {
                return true;
            }
            if (type2.equals("DECIMAL") && length2 - scale2 > 4) {
                return true;
            }
        } else if (type1.equals("INTEGER")) {
            if (type2.equals("INTEGER")) {
                return true;
            }
            if (type2.equals("BIGINT")) {
                return true;
            }
            if (type2.equals("FLOAT")) {
                return true;
            }
            if (type2.equals("DOUBLE")) {
                return true;
            }
            if (type2.equals("DECIMAL") && length2 - scale2 > 9) {
                return true;
            }
        } else if (type1.equals("DECIMAL")) {
            if (type2.equals("SMALLINT") && length1 < 5 && scale1 == 0) {
                return true;
            }
            if (type2.equals("INTEGER") && length1 < 10 && scale1 == 0) {
                return true;
            }
            if (type2.equals("BIGINT") && length1 < 19 && scale1 == 0) {
                return true;
            }
            if (type2.equals("FLOAT") && length1 < 7) {
                return true;
            }
            if (type2.equals("DOUBLE") && length1 < 16) {
                return true;
            }
            if (type2.equals("DECIMAL") && length2 >= length1 && scale2 >= scale1 && length2 - scale2 >= length1 - scale1) {
                return true;
            }
        } else if (type1.equals("FLOAT")) {
            if (type2.equals("FLOAT")) {
                return true;
            }
            if (type2.equals("DOUBLE")) {
                return true;
            }
        } else if (type1.equals("CHAR") || type1.equals("VARCHAR")) {
            if (type2.equals("CHAR") && length2 >= length1) {
                return true;
            }
            if (type2.equals("VARCHAR") && length2 >= length1) {
                return true;
            }
        } else if (type1.equals("GRAPHIC") || type1.equals("VARGRAPHIC")) {
            if (type2.equals("GRAPHIC") && length2 >= length1) {
                return true;
            }
            if (type2.equals("VARGRAPHIC") && length2 >= length1) {
                return true;
            }
        }
        return false;
    }

    public Object getOldContainerValue(EStructuralFeature feature, LUWDatabaseContainer container) {
        return this.getOldValue(feature, (EObject)container);
    }
}

