/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.actions;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanServiceRegistry;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.Messages;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.RemoveAllPlansAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.ShowPlanAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.ShowPlansAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.PlanView;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class PlanDropDownAction
extends Action
implements IMenuCreator {
    private Menu _fMenu;
    private PlanView _planView;

    public PlanDropDownAction(PlanView planView) {
        this.setText(Messages.PlanDropDownAction_previous_plans);
        this.setToolTipText(Messages.PlanDropDownAction_show_history);
        this.setImageDescriptor(Images.DESC_SHOWPLAN);
        this.setDisabledImageDescriptor(Images.DESC_SHOWPLAN);
        this._planView = planView;
        this.setMenuCreator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"plan_drop_down_action", (String)PlanViewPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void dispose() {
        this.disposeMenu();
    }

    public void disposeMenu() {
        if (this._fMenu != null) {
            this._fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        IPlanInstance[] instances = PlanViewPlugin.getPlanManager().getAllPlanInstances();
        IPlanInstance current = this._planView.getCurrentPlan();
        this.disposeMenu();
        this._fMenu = new Menu(parent);
        int i = instances.length - 1;
        while (i >= 0) {
            IPlanService service;
            boolean isGraphicPlan;
            IPlanInstance instance = instances[i];
            String label = String.valueOf(instance.getPlanRequest().getDatabaseDefinitionId()) + ": " + instance.getPlanRequest().getSql();
            if (label.length() > 40) {
                label = String.valueOf(label.substring(0, 37)) + " ...";
            }
            ImageDescriptor image = null;
            int planType = instance.getPlanRequest().getPlanType();
            image = instance.getStatus() == 2 ? Images.DESC_FAILED_PLAN : ((isGraphicPlan = (service = PlanServiceRegistry.getInstance().getPlanService(instance.getPlanRequest().getDatabaseDefinitionId())).getPlanOption().isGraphicPlan(planType)) ? Images.DESC_GRAPHIC_PLAN : Images.DESC_TEXT_PLAN);
            ShowPlanAction action = new ShowPlanAction(this._planView, instance, label, image, "");
            if (instances[i].equals(current)) {
                action.setChecked(true);
            }
            this.addActionToMenu(this._fMenu, action);
            --i;
        }
        if (instances.length > 0) {
            new MenuItem(this._fMenu, 2);
            this.addActionToMenu(this._fMenu, new RemoveAllPlansAction());
        }
        return this._fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowPlansAction(this._planView).run();
    }

    public void update() {
        this.setEnabled(PlanViewPlugin.getPlanManager().getAllPlanInstances().length != 0);
    }
}

