/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.GeneratorContainer;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.QueryContainer;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedTable;

public interface Entity
extends IdTypeMapping {
    public static final String SPECIFIED_NAME_PROPERTY = "specifiedName";
    public static final String DEFAULT_NAME_PROPERTY = "defaultName";
    public static final String SPECIFIED_SECONDARY_TABLES_LIST = "specifiedSecondaryTables";
    public static final String SPECIFIED_INHERITANCE_STRATEGY_PROPERTY = "specifiedInheritanceStrategy";
    public static final String DEFAULT_INHERITANCE_STRATEGY_PROPERTY = "defaultInheritanceStrategy";
    public static final String SPECIFIED_DISCRIMINATOR_VALUE_PROPERTY = "specifiedDiscriminatorValue";
    public static final String DEFAULT_DISCRIMINATOR_VALUE_PROPERTY = "defaultDiscriminatorValue";
    public static final String SPECIFIED_DISCRIMINATOR_VALUE_IS_ALLOWED_PROPERTY = "discriminatorValueIsAllowed";
    public static final String DISCRIMINATOR_VALUE_IS_UNDEFINED_PROPERTY = "discriminatorValueIsUndefined";
    public static final String SPECIFIED_DISCRIMINATOR_COLUMN_IS_ALLOWED_PROPERTY = "specifiedDiscriminatorColumnIsAllowed";
    public static final String DISCRIMINATOR_COLUMN_IS_UNDEFINED_PROPERTY = "discriminatorColumnIsUndefined";
    public static final String SPECIFIED_TABLE_IS_ALLOWED_PROPERTY = "specifiedTableIsAllowed";
    public static final String TABLE_IS_UNDEFINED_PROPERTY = "tableIsUndefined";
    public static final String SPECIFIED_PRIMARY_KEY_JOIN_COLUMNS_LIST = "specifiedPrimaryKeyJoinColumns";
    public static final String ROOT_ENTITY_PROPERTY = "rootEntity";
    public static final String DESCENDANTS_COLLECTION = "descendants";

    public String getSpecifiedName();

    public void setSpecifiedName(String var1);

    public String getDefaultName();

    public SpecifiedTable getTable();

    public String getPrimaryKeyColumnName();

    public String getDefaultTableName();

    public String getDefaultSchema();

    public String getDefaultCatalog();

    public ListIterable<? extends SecondaryTable> getSecondaryTables();

    public int getSecondaryTablesSize();

    public ListIterable<? extends SpecifiedSecondaryTable> getSpecifiedSecondaryTables();

    public int getSpecifiedSecondaryTablesSize();

    public SpecifiedSecondaryTable addSpecifiedSecondaryTable();

    public SpecifiedSecondaryTable addSpecifiedSecondaryTable(int var1);

    public void removeSpecifiedSecondaryTable(int var1);

    public void removeSpecifiedSecondaryTable(SpecifiedSecondaryTable var1);

    public void moveSpecifiedSecondaryTable(int var1, int var2);

    @Override
    public InheritanceType getInheritanceStrategy();

    public InheritanceType getSpecifiedInheritanceStrategy();

    public void setSpecifiedInheritanceStrategy(InheritanceType var1);

    public InheritanceType getDefaultInheritanceStrategy();

    public Entity getParentEntity();

    public SpecifiedDiscriminatorColumn getDiscriminatorColumn();

    public String getDiscriminatorValue();

    public String getSpecifiedDiscriminatorValue();

    public void setSpecifiedDiscriminatorValue(String var1);

    public String getDefaultDiscriminatorValue();

    public boolean specifiedDiscriminatorValueIsAllowed();

    public boolean discriminatorValueIsUndefined();

    public boolean specifiedDiscriminatorColumnIsAllowed();

    public boolean discriminatorColumnIsUndefined();

    public boolean specifiedTableIsAllowed();

    public boolean tableIsUndefined();

    public ListIterable<? extends PrimaryKeyJoinColumn> getPrimaryKeyJoinColumns();

    public int getPrimaryKeyJoinColumnsSize();

    public ListIterable<? extends SpecifiedPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns();

    public SpecifiedPrimaryKeyJoinColumn getSpecifiedPrimaryKeyJoinColumn(int var1);

    public int getSpecifiedPrimaryKeyJoinColumnsSize();

    public SpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int var1);

    public SpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn();

    public void removeSpecifiedPrimaryKeyJoinColumn(int var1);

    public void removeSpecifiedPrimaryKeyJoinColumn(SpecifiedPrimaryKeyJoinColumn var1);

    public void moveSpecifiedPrimaryKeyJoinColumn(int var1, int var2);

    public void convertDefaultPrimaryKeyJoinColumnsToSpecified();

    public void clearSpecifiedPrimaryKeyJoinColumns();

    public AttributeOverrideContainer getAttributeOverrideContainer();

    public AssociationOverrideContainer getAssociationOverrideContainer();

    public QueryContainer getQueryContainer();

    public GeneratorContainer getGeneratorContainer();

    @Override
    public Entity getRootEntity();

    public Iterable<Entity> getDescendants();

    public TextRange getNameTextRange();

    public boolean supportsValidationMessages();

    public AttributeMapping resolveAttributeMapping(String var1);

    public SpecifiedPersistentAttribute getIdAttribute();

    public static class IsDescendant
    extends PredicateAdapter<Entity> {
        private final String rootTypeName;

        public IsDescendant(Entity entity) {
            if (!entity.isRootEntity()) {
                throw new IllegalArgumentException("Entity must be root entity: " + String.valueOf(entity));
            }
            this.rootTypeName = entity.getPersistentType().getName();
        }

        public boolean evaluate(Entity entity) {
            return ObjectTools.notEquals((Object)this.rootTypeName, (Object)entity.getPersistentType().getName()) && ObjectTools.equals((Object)this.rootTypeName, (Object)entity.getRootEntity().getPersistentType().getName());
        }
    }
}

